/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CountingBucket {
    final AtomicLong numInversions = new AtomicLong();
    final AtomicLong numOps = new AtomicLong();
    final AtomicLong numSquarings = new AtomicLong();
    final AtomicLong numExps = new AtomicLong();
    final AtomicLong numRetrievedRepresentations = new AtomicLong();
    private final List<Integer> multiExpTermNumbers = new ArrayList<Integer>();
    private final Lock multiExpTermNumbersLock = new ReentrantLock();

    public void incrementNumOps() {
        this.numOps.incrementAndGet();
    }

    public void incrementNumInversions() {
        this.numInversions.incrementAndGet();
    }

    public void incrementNumSquarings() {
        this.numSquarings.incrementAndGet();
    }

    public void incrementNumExps() {
        this.numExps.incrementAndGet();
    }

    public void addMultiExpBaseNumber(int numTerms) {
        this.multiExpTermNumbersLock.lock();
        try {
            if (numTerms > 1) {
                this.multiExpTermNumbers.add(numTerms);
            }
        }
        finally {
            this.multiExpTermNumbersLock.unlock();
        }
    }

    public void addAllMultiExpBaseNumbers(List<Integer> newTerms) {
        this.multiExpTermNumbersLock.lock();
        try {
            this.multiExpTermNumbers.addAll(newTerms);
        }
        finally {
            this.multiExpTermNumbersLock.unlock();
        }
    }

    void incrementNumRetrievedRepresentations() {
        this.numRetrievedRepresentations.incrementAndGet();
    }

    public long getNumInversions() {
        return this.numInversions.get();
    }

    public long getNumOps() {
        return this.numOps.get();
    }

    public long getNumSquarings() {
        return this.numSquarings.get();
    }

    public long getNumExps() {
        return this.numExps.get();
    }

    public long getNumRetrievedRepresentations() {
        return this.numRetrievedRepresentations.get();
    }

    public List<Integer> getMultiExpTermNumbers() {
        return Collections.unmodifiableList(this.multiExpTermNumbers);
    }

    public void resetCounters() {
        this.resetOpsCounter();
        this.resetInversionsCounter();
        this.resetSquaringsCounter();
        this.resetExpsCounter();
        this.resetMultiExpTermNumbers();
        this.resetRetrievedRepresentationsCounter();
    }

    protected void resetOpsCounter() {
        this.numOps.set(0L);
    }

    protected void resetInversionsCounter() {
        this.numInversions.set(0L);
    }

    protected void resetSquaringsCounter() {
        this.numSquarings.set(0L);
    }

    protected void resetExpsCounter() {
        this.numExps.set(0L);
    }

    protected void resetMultiExpTermNumbers() {
        this.multiExpTermNumbersLock.lock();
        try {
            this.multiExpTermNumbers.clear();
        }
        finally {
            this.multiExpTermNumbersLock.unlock();
        }
    }

    protected void resetRetrievedRepresentationsCounter() {
        this.numRetrievedRepresentations.set(0L);
    }

    protected boolean isEmpty() {
        return this.numOps.get() == 0L && this.numInversions.get() == 0L && this.numSquarings.get() == 0L && this.numExps.get() == 0L && this.getMultiExpTermNumbers().isEmpty() && this.numRetrievedRepresentations.get() == 0L;
    }
}

