/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.debug.CountingBucket;
import org.cryptimeleon.math.structures.groups.debug.DebugGroupImplTotal;

public class DebugGroupImplGTTotal
extends DebugGroupImplTotal {
    private static final ConcurrentHashMap<String, CountingBucket> countingBucketMap = new ConcurrentHashMap();
    private static final CountingBucket defaultBucket;
    private static volatile CountingBucket currentBucket;

    public DebugGroupImplGTTotal(String name, BigInteger n) {
        super(name, n);
    }

    public DebugGroupImplGTTotal(Representation repr) {
        super(repr);
    }

    @Override
    public boolean implementsOwnExp() {
        return false;
    }

    @Override
    public boolean implementsOwnMultiExp() {
        return false;
    }

    @Override
    void setBucket(String name) {
        currentBucket = this.putBucketIfAbsent(name);
    }

    @Override
    void setDefaultBucket() {
        currentBucket = defaultBucket;
    }

    @Override
    CountingBucket putBucketIfAbsent(String name) {
        return countingBucketMap.computeIfAbsent(name, kName -> new CountingBucket());
    }

    @Override
    CountingBucket getCurrentBucket() {
        return currentBucket;
    }

    @Override
    CountingBucket getDefaultBucket() {
        return defaultBucket;
    }

    @Override
    Map<String, CountingBucket> getBucketMap() {
        return countingBucketMap;
    }

    static {
        currentBucket = defaultBucket = new CountingBucket();
    }
}

