/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.exp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.MultiExpAlgorithm;
import org.cryptimeleon.math.structures.groups.exp.MultiExpTerm;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;

public class Multiexponentiation {
    ArrayList<MultiExpTerm> terms = null;
    GroupElementImpl constantFactor = null;

    public void put(MultiExpTerm term) {
        if (this.terms == null) {
            this.terms = new ArrayList();
        }
        this.terms.add(term);
    }

    public void put(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        this.put(new MultiExpTerm(base, exponent, precomputation));
    }

    public void put(GroupElementImpl groupelem) {
        this.constantFactor = this.constantFactor == null ? groupelem : this.constantFactor.op(groupelem);
    }

    public void ensurePrecomputation(int windowSize, MultiExpAlgorithm multiExpAlgorithm) {
        if (this.terms != null) {
            block4: for (MultiExpTerm term : this.terms) {
                switch (multiExpAlgorithm) {
                    case SLIDING: {
                        boolean invertExisting;
                        boolean bl = invertExisting = term.getBase().getStructure().estimateCostInvPerOp() > 1.0;
                        if (term.getExponent().signum() < 0) {
                            term.getPrecomputation().computeNegativePowers(windowSize, invertExisting);
                            break;
                        }
                        term.getPrecomputation().compute(windowSize, invertExisting);
                        break;
                    }
                    case WNAF: {
                        boolean precNegativePowers;
                        if (term.getPrecomputation().getCurrentlySupportedWindowSize() >= windowSize) continue block4;
                        boolean bl = precNegativePowers = term.getPrecomputation().getCurrentlySupportedNegativeWindowSize() > term.getPrecomputation().getCurrentlySupportedPositiveWindowSize();
                        if (precNegativePowers) {
                            term.getPrecomputation().computeNegativePowers(windowSize, false);
                            break;
                        }
                        term.getPrecomputation().compute(windowSize, false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported MultiExpAlgorithm " + (Object)((Object)multiExpAlgorithm));
                    }
                }
            }
        }
    }

    public int computeMinPrecomputedWindowSize(MultiExpAlgorithm multiExpAlgorithm) {
        if (this.terms == null) {
            return 0;
        }
        int minPrecomputedWindowSize = Integer.MAX_VALUE;
        block4: for (MultiExpTerm term : this.terms) {
            switch (multiExpAlgorithm) {
                case SLIDING: {
                    if (term.getExponent().signum() >= 0) {
                        minPrecomputedWindowSize = Math.min(minPrecomputedWindowSize, term.precomputation == null ? 0 : term.precomputation.getCurrentlySupportedPositiveWindowSize());
                        continue block4;
                    }
                    minPrecomputedWindowSize = Math.min(minPrecomputedWindowSize, term.precomputation == null ? 0 : term.precomputation.getCurrentlySupportedNegativeWindowSize());
                    continue block4;
                }
                case WNAF: {
                    minPrecomputedWindowSize = Math.min(minPrecomputedWindowSize, term.precomputation == null ? 0 : term.precomputation.getCurrentlySupportedWindowSize());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported MultiExpAlgorithm " + (Object)((Object)multiExpAlgorithm));
        }
        return minPrecomputedWindowSize;
    }

    public List<MultiExpTerm> getTerms() {
        return this.terms == null ? Collections.emptyList() : Collections.unmodifiableList(this.terms);
    }

    public int getNumberOfTerms() {
        return this.terms == null ? 0 : this.terms.size();
    }

    public Optional<GroupElementImpl> getConstantFactor() {
        return Optional.ofNullable(this.constantFactor);
    }

    public boolean isEmpty() {
        return (this.terms == null || this.terms.size() == 0) && this.constantFactor == null;
    }

    public String toString() {
        StringBuilder stringRepr = new StringBuilder();
        stringRepr.append("Multiexponentiation:");
        this.terms.forEach(t -> stringRepr.append("\n").append(t.toString()));
        return stringRepr.toString();
    }
}

