/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.sn;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.BigIntegerRepresentation;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;

public class Sn
implements GroupImpl {
    protected int n;
    private SnElementImpl identity = null;

    public Sn(int n) {
        this.n = n;
    }

    public Sn(Representation repr) {
        this.n = repr.bigInt().get().intValue();
    }

    public int getN() {
        return this.n;
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        BigInteger size = BigInteger.ONE;
        for (int i = 2; i <= this.n; ++i) {
            size = size.multiply(BigInteger.valueOf(i));
        }
        return size;
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        return this.n == 2;
    }

    @Override
    public double estimateCostInvPerOp() {
        return 1.0;
    }

    @Override
    public Representation getRepresentation() {
        return new BigIntegerRepresentation(BigInteger.valueOf(this.n));
    }

    @Override
    public SnElementImpl getNeutralElement() {
        if (this.identity == null) {
            this.identity = new SnElementImpl(Function.identity());
        }
        return this.identity;
    }

    @Override
    public SnElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        ArrayList<Integer> images = new ArrayList<Integer>();
        for (int i2 = 1; i2 <= this.n; ++i2) {
            images.add(i2);
        }
        Collections.shuffle(images);
        return new SnElementImpl(i -> (Integer)images.get(i - 1));
    }

    @Override
    public SnElementImpl restoreElement(Representation repr) {
        return new SnElementImpl(repr);
    }

    @Override
    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private SnElementImpl createElement(int[] images) {
        SnElementImpl result = new SnElementImpl();
        result.images = images;
        return result;
    }

    public static SnElementImpl createElementFromString(String str) {
        Sn sn;
        str = str.substring(1, str.length() - 1);
        Integer[] ints = (Integer[])Arrays.stream(str.split(" ")).map(s -> Integer.parseInt(s)).toArray(Integer[]::new);
        int n = ints.length - 1;
        Sn sn2 = sn = new Sn(n);
        sn2.getClass();
        return sn2.new SnElementImpl(i -> ints[i - 1]);
    }

    public int hashCode() {
        return this.n;
    }

    public boolean equals(Object obj) {
        return obj instanceof Sn && ((Sn)obj).n == this.n;
    }

    public String toString() {
        return "S" + this.n;
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return Optional.of(this.n * BigInteger.valueOf(this.n).toByteArray().length);
    }

    @Override
    public boolean isCommutative() {
        return this.n <= 2;
    }

    public class SnElementImpl
    implements GroupElementImpl,
    Function<Integer, Integer> {
        protected int[] images;

        private SnElementImpl() {
        }

        public SnElementImpl(Representation repr) {
            this((Integer i) -> repr.list().get((int)i).bigInt().get().intValue());
        }

        public SnElementImpl(Function<Integer, Integer> permutation) {
            this.images = new int[Sn.this.n + 1];
            for (int i = 1; i <= Sn.this.n; ++i) {
                this.images[i] = permutation.apply(i);
            }
        }

        public SnElementImpl(int[] images) {
            this.images = Arrays.copyOf(images, Sn.this.n + 1);
            if (!this.checkValidElement()) {
                throw new IllegalArgumentException(this + " is not a permutation");
            }
        }

        public boolean checkValidElement() {
            try {
                int[] inverse = new int[Sn.this.n + 1];
                for (int i = 1; i <= Sn.this.n; ++i) {
                    if (inverse[this.images[i]] != 0) {
                        return false;
                    }
                    inverse[this.images[i]] = i;
                }
                this.images[0] = 1;
                if (!Arrays.stream(inverse).allMatch(x -> x > 0)) {
                    return false;
                }
                this.images[0] = 0;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return false;
            }
            return true;
        }

        @Override
        public Representation getRepresentation() {
            ListRepresentation repr = new ListRepresentation();
            Arrays.stream(this.images).mapToObj(i -> new BigIntegerRepresentation(i)).forEachOrdered(x -> repr.put((Representation)x));
            return repr;
        }

        @Override
        public GroupImpl getStructure() {
            return Sn.this;
        }

        @Override
        public SnElementImpl inv() {
            int[] inverse = new int[Sn.this.n + 1];
            for (int i = 0; i <= Sn.this.n; ++i) {
                inverse[this.images[i]] = i;
            }
            return Sn.this.createElement(inverse);
        }

        @Override
        public SnElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
            if (!e.getStructure().equals(this.getStructure())) {
                throw new IllegalArgumentException("Trying to operate on elements of two different groups");
            }
            int[] rhs = ((SnElementImpl)e).images;
            int[] lhs = this.images;
            int[] result = new int[Sn.this.n + 1];
            for (int i = 1; i <= Sn.this.n; ++i) {
                result[i] = lhs[rhs[i]];
            }
            return Sn.this.createElement(result);
        }

        public int hashCode() {
            return Arrays.hashCode(this.images);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SnElementImpl) || !((SnElementImpl)obj).getStructure().equals(this.getStructure())) {
                return false;
            }
            return Arrays.equals(((SnElementImpl)obj).images, this.images);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            for (int i = 1; i <= Sn.this.n; ++i) {
                builder.append(i == 1 ? "" : " ").append(this.images[i]);
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public Integer apply(Integer i) {
            return this.images[i];
        }

        @Override
        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            int nLength = BigInteger.valueOf(Sn.this.n).toByteArray().length;
            for (int i = 1; i <= Sn.this.n; ++i) {
                int j = this.images[i];
                BigInteger bigI = BigInteger.valueOf(j);
                accumulator.appendPadded(nLength, bigI.toByteArray());
            }
            return accumulator;
        }
    }
}

