/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.polynomial;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class PolynomialRing
implements Ring {
    protected Ring baseRing;

    public PolynomialRing(Ring base) {
        this.baseRing = base;
        if (!this.baseRing.isCommutative()) {
            throw new IllegalArgumentException("base ring of polynomial ring must be commutative");
        }
    }

    public PolynomialRing(Representation arg) {
        RepresentableRepresentation repr = (RepresentableRepresentation)arg;
        this.baseRing = (Ring)repr.recreateRepresentable();
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public Representation getRepresentation() {
        return new RepresentableRepresentation(this.baseRing);
    }

    @Override
    public BigInteger sizeUnitGroup() throws UnsupportedOperationException {
        return this.baseRing.sizeUnitGroup();
    }

    @Override
    public Polynomial getZeroElement() {
        return new Polynomial(this.baseRing.getZeroElement());
    }

    @Override
    public Polynomial getOneElement() {
        return new Polynomial(this.baseRing.getOneElement());
    }

    public Polynomial getX() {
        return new Polynomial(1);
    }

    @Override
    public Polynomial getElement(BigInteger i) {
        return new Polynomial(this.baseRing.getElement(i));
    }

    @Override
    public double estimateCostInvPerOp() {
        return this.baseRing.estimateCostInvPerOp();
    }

    @Override
    public double estimateCostNegPerOp() {
        return this.baseRing.estimateCostNegPerOp();
    }

    public Ring getBaseRing() {
        return this.baseRing;
    }

    @Override
    public Polynomial restoreElement(Representation arg) {
        ListRepresentation repr = (ListRepresentation)arg;
        RingElement[] coefficients = new RingElement[repr.size()];
        for (int i = 0; i < repr.size(); ++i) {
            coefficients[i] = this.baseRing.restoreElement(repr.get(i));
        }
        return new Polynomial(coefficients);
    }

    @Override
    public Polynomial getUniformlyRandomElement() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("infinite ring");
    }

    @Override
    public Polynomial getUniformlyRandomUnit() throws UnsupportedOperationException {
        return new Polynomial(this.baseRing.getUniformlyRandomUnit());
    }

    public boolean equals(Object obj) {
        return obj instanceof PolynomialRing && ((PolynomialRing)obj).getBaseRing().equals(this.baseRing);
    }

    public int hashCode() {
        return 1 + this.baseRing.hashCode();
    }

    @Override
    public BigInteger getCharacteristic() {
        return this.getBaseRing().getCharacteristic();
    }

    public Polynomial valueOf(RingElement ... coefficients) {
        return PolynomialRing.getPoly(coefficients);
    }

    public static Polynomial getPoly(RingElement ... coefficients) {
        PolynomialRing r;
        if (coefficients.length == 0) {
            throw new IllegalArgumentException("Empty coefficients");
        }
        PolynomialRing polynomialRing = r = new PolynomialRing(coefficients[0].getStructure());
        polynomialRing.getClass();
        return polynomialRing.new Polynomial(coefficients);
    }

    public static Polynomial getPoly(Map<? extends RingElement, ? extends RingElement> dataPoints, int degreeOfPolynomial) {
        if (dataPoints == null || dataPoints.isEmpty()) {
            throw new IllegalArgumentException("No data points provided for interpolation");
        }
        if (degreeOfPolynomial < 0) {
            throw new IllegalArgumentException("Degree of polynomial must be positive");
        }
        if (dataPoints.size() < degreeOfPolynomial + 1) {
            throw new IllegalArgumentException("Not enough data points provided for interpolation. Needed: " + (degreeOfPolynomial + 1) + " ; Got " + dataPoints.size());
        }
        Ring ring = dataPoints.keySet().stream().map(RingElement::getStructure).findFirst().get();
        int numberOfCoefficients = degreeOfPolynomial + 1;
        RingElement[] xValues = dataPoints.keySet().toArray(new RingElement[dataPoints.size()]);
        Object[] coefficients = new Zp.ZpElement[numberOfCoefficients];
        Arrays.fill(coefficients, ring.getZeroElement());
        RingElement[] c = new RingElement[numberOfCoefficients + 1];
        c[0] = ring.getOneElement();
        for (int i = 0; i < numberOfCoefficients; ++i) {
            for (int j = i; j > 0; --j) {
                c[j] = c[j - 1].add(c[j].mul(xValues[i]).neg());
            }
            c[0] = c[0].mul(xValues[i].neg());
            c[i + 1] = ring.getOneElement();
        }
        RingElement[] tc = new RingElement[numberOfCoefficients];
        for (int i = 0; i < numberOfCoefficients; ++i) {
            RingElement d = ring.getOneElement();
            for (int j = 0; j < numberOfCoefficients; ++j) {
                if (i == j) continue;
                d = d.mul(xValues[i].add(xValues[j].neg()));
            }
            RingElement t = dataPoints.get(xValues[i]).mul(d.inv());
            tc[numberOfCoefficients - 1] = c[numberOfCoefficients];
            coefficients[numberOfCoefficients - 1] = ((Zp.ZpElement)coefficients[numberOfCoefficients - 1]).add(t.mul(tc[numberOfCoefficients - 1]));
            for (int j = numberOfCoefficients - 2; j >= 0; --j) {
                tc[j] = c[j + 1].add(tc[j + 1].mul(xValues[i]));
                coefficients[j] = ((Zp.ZpElement)coefficients[j]).add(t.mul(tc[j]));
            }
        }
        PolynomialRing polynomialRing = new PolynomialRing(ring);
        polynomialRing.getClass();
        return polynomialRing.new Polynomial((RingElement[])coefficients);
    }

    public static Polynomial getPoly(Map<? extends RingElement, ? extends RingElement> dataPoints) {
        return PolynomialRing.getPoly(dataPoints, dataPoints.size() - 1);
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return Optional.empty();
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    public class Polynomial
    implements RingElement {
        protected RingElement[] coefficients;
        protected int degree;

        private Polynomial() {
        }

        private Polynomial createPolyInternal(RingElement[] coefficients) {
            if (coefficients.length == 0) {
                throw new IllegalArgumentException("Empty coefficient list for polynomial");
            }
            Polynomial result = new Polynomial();
            result.coefficients = coefficients;
            result.computeDegree();
            return result;
        }

        public RingElement[] getCoefficients() {
            return Arrays.copyOf(this.coefficients, this.coefficients.length);
        }

        public RingElementVector getCoefficientVector() {
            return new RingElementVector(this.getCoefficients());
        }

        public Polynomial(RingElement ... coefficients) {
            if (coefficients.length == 0) {
                coefficients = new RingElement[]{PolynomialRing.this.baseRing.getZeroElement()};
            }
            this.coefficients = Arrays.copyOf(coefficients, coefficients.length);
            this.computeDegree();
            this.ensureArrayNonNull();
        }

        public Polynomial(List<RingElement> coefficients) {
            if (coefficients.size() == 0) {
                coefficients = Collections.singletonList(PolynomialRing.this.baseRing.getZeroElement());
            }
            this.coefficients = coefficients.toArray(new RingElement[coefficients.size()]);
            this.computeDegree();
            this.ensureArrayNonNull();
        }

        public Polynomial(int i, RingElement a) {
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            this.degree = a.isZero() ? 0 : i;
            this.coefficients = new RingElement[this.degree + 1];
            this.coefficients[this.degree] = a;
            for (int j = 0; j < this.degree; ++j) {
                this.coefficients[j] = PolynomialRing.this.baseRing.getZeroElement();
            }
        }

        public Polynomial(int i) {
            this(i, this$0.baseRing.getOneElement());
        }

        protected void computeDegree() {
            this.degree = this.coefficients.length - 1;
            while (this.degree > 0 && (this.coefficients[this.degree] == null || this.coefficients[this.degree].isZero())) {
                --this.degree;
            }
        }

        protected void ensureArrayNonNull() {
            for (int i = 0; i <= this.degree; ++i) {
                if (this.coefficients[i] != null) continue;
                throw new IllegalArgumentException("There are null values in this polynomial.");
            }
        }

        @Override
        public Representation getRepresentation() {
            ListRepresentation result = new ListRepresentation();
            for (RingElement elem : this.coefficients) {
                result.put(elem.getRepresentation());
            }
            return result;
        }

        @Override
        public PolynomialRing getStructure() {
            return PolynomialRing.this;
        }

        public RingElement evaluate(Element x) {
            if (!x.getStructure().equals(PolynomialRing.this.baseRing)) {
                throw new UnsupportedOperationException("Evaluate only supports elements from the base ring as argument");
            }
            RingElement result = PolynomialRing.this.baseRing.getZeroElement();
            for (int i = this.coefficients.length; i > 0; --i) {
                result = this.coefficients[i - 1].add(result.mul(x));
            }
            return result;
        }

        @Override
        public Polynomial add(Element e) {
            int i;
            if (e.getStructure().equals(PolynomialRing.this.getBaseRing())) {
                return this.add(new Polynomial((RingElement)e));
            }
            Polynomial[] polys = new Polynomial[]{this, (Polynomial)e};
            Arrays.sort(polys, Comparator.comparing(p -> p.degree));
            RingElement[] result = new RingElement[polys[1].degree + 1];
            for (i = 0; i <= polys[0].degree; ++i) {
                result[i] = polys[0].coefficients[i].add(polys[1].coefficients[i]);
            }
            for (i = polys[0].degree + 1; i <= polys[1].degree; ++i) {
                result[i] = polys[1].coefficients[i];
            }
            return this.createPolyInternal(result);
        }

        @Override
        public Polynomial neg() {
            RingElement[] result = new RingElement[this.degree + 1];
            for (int i = 0; i <= this.degree; ++i) {
                result[i] = this.coefficients[i].neg();
            }
            return this.createPolyInternal(result);
        }

        public Zp.ZpElement innerProduct(Polynomial e) {
            if (!(PolynomialRing.this.baseRing instanceof Zp) || !(e.getStructure().baseRing instanceof Zp)) {
                throw new UnsupportedOperationException("Only supported for ZpElements");
            }
            Zp.ZpElement result = (Zp.ZpElement)PolynomialRing.this.baseRing.getZeroElement();
            int minLength = Math.min(e.coefficients.length, this.coefficients.length);
            for (int i = 0; i < minLength; ++i) {
                result = result.add(this.coefficients[i].mul(e.coefficients[i]));
            }
            return result;
        }

        @Override
        public Polynomial sub(Element e) {
            int i;
            if (e.getStructure().equals(PolynomialRing.this.getBaseRing())) {
                return this.sub(new Polynomial((RingElement)e));
            }
            Polynomial[] polys = new Polynomial[]{this, (Polynomial)e};
            Arrays.sort(polys, Comparator.comparing(p -> p.degree));
            RingElement[] result = new RingElement[polys[1].degree + 1];
            for (i = 0; i <= polys[0].degree; ++i) {
                result[i] = this.coefficients[i].sub(((Polynomial)e).coefficients[i]);
            }
            for (i = polys[0].degree + 1; i <= polys[1].degree; ++i) {
                result[i] = polys[1] == e ? polys[1].coefficients[i].neg() : polys[1].coefficients[i];
            }
            return this.createPolyInternal(result);
        }

        @Override
        public Polynomial mul(Element e) {
            int i;
            if (e.getStructure().equals(PolynomialRing.this.getBaseRing())) {
                return this.scalarMul(e);
            }
            Polynomial a = (Polynomial)e;
            Polynomial b = this;
            RingElement[] result = new RingElement[a.degree + b.degree + 1];
            RingElement zero = PolynomialRing.this.baseRing.getZeroElement();
            for (i = 0; i < result.length; ++i) {
                result[i] = zero;
            }
            for (i = 0; i <= a.degree; ++i) {
                for (int j = 0; j <= b.degree; ++j) {
                    result[i + j] = result[i + j].add(a.coefficients[i].mul(b.coefficients[j]));
                }
            }
            return this.createPolyInternal(result);
        }

        @Override
        public Polynomial mul(BigInteger k) {
            RingElement[] result = new RingElement[this.degree + 1];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.coefficients[i].mul(k);
            }
            return this.createPolyInternal(result);
        }

        @Override
        public Polynomial inv() throws UnsupportedOperationException {
            if (this.degree > 0) {
                throw new UnsupportedOperationException("Cannot invert non-zero-degree polynomials");
            }
            return new Polynomial(this.coefficients[0].inv());
        }

        public Polynomial scalarMul(Element elem) {
            RingElement[] result = new RingElement[this.degree + 1];
            for (int i = 0; i <= this.degree; ++i) {
                result[i] = this.coefficients[i].mul(elem);
            }
            return this.createPolyInternal(result);
        }

        public Polynomial normalize() throws UnsupportedOperationException {
            return this.scalarMul(this.coefficients[this.degree].inv());
        }

        @Override
        public boolean divides(RingElement e) throws UnsupportedOperationException {
            if (e.isZero()) {
                return true;
            }
            return e.divideWithRemainder(this)[1].isZero();
        }

        public Polynomial[] divideWithRemainder(RingElement e) throws UnsupportedOperationException {
            Polynomial divisor = (Polynomial)e;
            Polynomial dividend = this;
            Polynomial quotient = PolynomialRing.this.getZeroElement();
            RingElement invOfLeadingCoeff = divisor.coefficients[divisor.degree].inv();
            while (!dividend.isZero() && dividend.getDegree() >= divisor.getDegree()) {
                int k = dividend.getDegree() - divisor.getDegree();
                RingElement t = dividend.coefficients[dividend.degree].mul(invOfLeadingCoeff);
                PolynomialRing polynomialRing = dividend.getStructure();
                polynomialRing.getClass();
                Polynomial temp = polynomialRing.new Polynomial(k, t);
                quotient = quotient.add(temp);
                dividend = dividend.sub(divisor.mul(temp));
            }
            Polynomial remainder = dividend;
            return new Polynomial[]{quotient, remainder};
        }

        @Override
        public BigInteger asInteger() throws UnsupportedOperationException {
            if (this.getDegree() > 0) {
                throw new UnsupportedOperationException("Not an integer: " + this);
            }
            return this.coefficients[0].asInteger();
        }

        @Override
        public BigInteger getRank() throws UnsupportedOperationException {
            return BigInteger.valueOf(this.getDegree());
        }

        public int getDegree() {
            return this.degree;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Polynomial obj = (Polynomial)o;
            if (obj.degree != this.degree) {
                return false;
            }
            for (int i = 0; i <= this.degree; ++i) {
                if (obj.coefficients[i].equals(this.coefficients[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int result = 0;
            for (int i = 0; i <= this.degree; ++i) {
                result += this.coefficients[i].hashCode() * i;
            }
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            for (int i = this.degree; i >= 0; --i) {
                if (i < this.degree) {
                    builder.append("+");
                }
                builder.append(this.coefficients[i].toString());
                if (i <= 0) continue;
                builder.append("x");
                if (i <= 1) continue;
                builder.append("^" + i);
            }
            return builder.append("]").toString();
        }

        @Override
        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            for (RingElement elem : this.getCoefficients()) {
                accumulator.escapeAndAppend(elem.getUniqueByteRepresentation());
                accumulator.appendSeperator();
            }
            return accumulator;
        }
    }
}

