/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.G2;
import com.herumi.mcl.Mcl;
import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclBilinearGroup;
import org.cryptimeleon.mclwrap.bn254.MclGroup2ElementImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroupImpl;

class MclGroup2Impl
extends MclGroupImpl {
    protected MclGroup2ElementImpl generator = null;

    public MclGroup2Impl(MclBilinearGroup.GroupChoice groupChoice) {
        super(groupChoice);
    }

    public MclGroup2Impl(Representation repr) {
        super(repr);
    }

    @Override
    public MclGroup2ElementImpl getElement(String string) {
        return this.createElement(this.getInternalObjectFromString(string));
    }

    public GroupElementImpl restoreElement(Representation repr) {
        return new MclGroup2ElementImpl(this, repr);
    }

    @Override
    protected G2 getInternalObjectFromString(String str) {
        G2 result = new G2();
        result.setStr(str);
        return result;
    }

    protected MclGroup2ElementImpl createElement(G2 G22) {
        return new MclGroup2ElementImpl(this, G22);
    }

    public MclGroup2ElementImpl getNeutralElement() {
        return this.getElement("0");
    }

    public MclGroup2ElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.getGenerator().pow(RandomGenerator.getRandomNumber((BigInteger)this.size()));
    }

    public MclGroup2ElementImpl getGenerator() throws UnsupportedOperationException {
        if (this.generator != null) {
            return this.generator;
        }
        G2 res = new G2();
        Mcl.hashAndMapToG2(res, "some arbitrary element".getBytes());
        this.generator = this.createElement(res);
        return this.generator;
    }

    public double estimateCostInvPerOp() {
        switch (this.groupChoice) {
            case BN254: {
                return 2.3;
            }
            case BLS12_381: {
                return 3.3;
            }
        }
        throw new IllegalArgumentException("Unknown cost estimate.");
    }
}

