/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.mclwrap.bn254;

import com.herumi.mcl.G2;
import com.herumi.mcl.Mcl;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.mclwrap.bn254.MclGroup2Impl;

class MclHashIntoG2Impl
implements HashIntoGroupImpl {
    protected MclGroup2Impl group;

    public MclHashIntoG2Impl(MclGroup2Impl group) {
        this.group = group;
    }

    public MclHashIntoG2Impl(Representation repr) {
        this.group = new MclGroup2Impl(repr);
    }

    public GroupElementImpl hashIntoGroupImpl(byte[] x) {
        G2 result = new G2();
        Mcl.hashAndMapToG2(result, x);
        return this.group.createElement(result);
    }

    public Representation getRepresentation() {
        return this.group.getRepresentation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MclHashIntoG2Impl that = (MclHashIntoG2Impl)o;
        return this.group.equals(that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }
}

