/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.common.MasterkeyBackupFileHasher;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.KeyFile;

@Module(subcomponents={AttributeViewComponent.class, OpenCryptoFileComponent.class, DirectoryStreamComponent.class})
class CryptoFileSystemModule {
    CryptoFileSystemModule() {
    }

    @Provides
    @CryptoFileSystemScoped
    public Cryptor provideCryptor(CryptorProvider cryptorProvider, @PathToVault Path pathToVault, CryptoFileSystemProperties properties, ReadonlyFlag readonlyFlag) {
        try {
            Path masterKeyPath = pathToVault.resolve(properties.masterkeyFilename());
            assert (Files.exists(masterKeyPath, new LinkOption[0]));
            byte[] keyFileContents = Files.readAllBytes(masterKeyPath);
            Path backupKeyPath = pathToVault.resolve(properties.masterkeyFilename() + MasterkeyBackupFileHasher.generateFileIdSuffix(keyFileContents) + ".bkup");
            Cryptor cryptor = cryptorProvider.createFromKeyFile(KeyFile.parse((byte[])keyFileContents), properties.passphrase(), properties.pepper(), 7);
            this.backupMasterkeyFileIfRequired(masterKeyPath, backupKeyPath, readonlyFlag);
            return cryptor;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void backupMasterkeyFileIfRequired(Path masterKeyPath, Path backupKeyPath, ReadonlyFlag readonlyFlag) throws IOException {
        if (!readonlyFlag.isSet()) {
            Files.copy(masterKeyPath, backupKeyPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

