/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Strings;
import java.text.Normalizer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CryptoFileSystemProperties
extends AbstractMap<String, Object> {
    public static final String PROPERTY_PASSPHRASE = "passphrase";
    public static final String PROPERTY_PEPPER = "pepper";
    static final byte[] DEFAULT_PEPPER = new byte[0];
    public static final String PROPERTY_MASTERKEY_FILENAME = "masterkeyFilename";
    static final String DEFAULT_MASTERKEY_FILENAME = "masterkey.cryptomator";
    public static final String PROPERTY_FILESYSTEM_FLAGS = "flags";
    static final Set<FileSystemFlags> DEFAULT_FILESYSTEM_FLAGS = Collections.unmodifiableSet(EnumSet.of(FileSystemFlags.MIGRATE_IMPLICITLY, FileSystemFlags.INIT_IMPLICITLY));
    private final Set<Map.Entry<String, Object>> entries;

    private CryptoFileSystemProperties(Builder builder) {
        this.entries = Collections.unmodifiableSet(new HashSet<Map.Entry>(Arrays.asList(CryptoFileSystemProperties.entry(PROPERTY_PASSPHRASE, builder.passphrase), CryptoFileSystemProperties.entry(PROPERTY_PEPPER, builder.pepper), CryptoFileSystemProperties.entry(PROPERTY_FILESYSTEM_FLAGS, builder.flags), CryptoFileSystemProperties.entry(PROPERTY_MASTERKEY_FILENAME, builder.masterkeyFilename))));
    }

    CharSequence passphrase() {
        return (CharSequence)this.get(PROPERTY_PASSPHRASE);
    }

    byte[] pepper() {
        return (byte[])this.get(PROPERTY_PEPPER);
    }

    public Set<FileSystemFlags> flags() {
        return (Set)this.get(PROPERTY_FILESYSTEM_FLAGS);
    }

    public boolean readonly() {
        return this.flags().contains((Object)FileSystemFlags.READONLY);
    }

    boolean migrateImplicitly() {
        return this.flags().contains((Object)FileSystemFlags.MIGRATE_IMPLICITLY);
    }

    boolean initializeImplicitly() {
        return this.flags().contains((Object)FileSystemFlags.INIT_IMPLICITLY);
    }

    String masterkeyFilename() {
        return (String)this.get(PROPERTY_MASTERKEY_FILENAME);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entries;
    }

    private static Map.Entry<String, Object> entry(final String key, final Object value) {
        return new Map.Entry<String, Object>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Object getValue() {
                return value;
            }

            @Override
            public Object setValue(Object value2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Builder cryptoFileSystemProperties() {
        return new Builder();
    }

    public static Builder withPassphrase(CharSequence passphrase) {
        return new Builder().withPassphrase(passphrase);
    }

    public static Builder cryptoFileSystemPropertiesFrom(Map<String, ?> properties) {
        return new Builder(properties);
    }

    public static CryptoFileSystemProperties wrap(Map<String, ?> properties) {
        if (properties instanceof CryptoFileSystemProperties) {
            return (CryptoFileSystemProperties)properties;
        }
        try {
            return CryptoFileSystemProperties.cryptoFileSystemPropertiesFrom(properties).build();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private CharSequence passphrase;
        public byte[] pepper = DEFAULT_PEPPER;
        private final Set<FileSystemFlags> flags = EnumSet.copyOf(DEFAULT_FILESYSTEM_FLAGS);
        private String masterkeyFilename = "masterkey.cryptomator";

        private Builder() {
        }

        private Builder(Map<String, ?> properties) {
            this.checkedSet(CharSequence.class, CryptoFileSystemProperties.PROPERTY_PASSPHRASE, properties, this::withPassphrase);
            this.checkedSet(byte[].class, CryptoFileSystemProperties.PROPERTY_PEPPER, properties, this::withPepper);
            this.checkedSet(String.class, CryptoFileSystemProperties.PROPERTY_MASTERKEY_FILENAME, properties, this::withMasterkeyFilename);
            this.checkedSet(Set.class, CryptoFileSystemProperties.PROPERTY_FILESYSTEM_FLAGS, properties, this::withFlags);
        }

        private <T> void checkedSet(Class<T> type, String key, Map<String, ?> properties, Consumer<T> setter) {
            Object value = properties.get(key);
            if (value == null) {
                return;
            }
            if (!type.isInstance(value)) {
                throw new IllegalArgumentException(key + " must be of type " + type.getSimpleName());
            }
            setter.accept(type.cast(value));
        }

        public Builder withPassphrase(CharSequence passphrase) {
            this.passphrase = Normalizer.normalize(passphrase, Normalizer.Form.NFC);
            return this;
        }

        public Builder withPepper(byte[] pepper) {
            this.pepper = pepper;
            return this;
        }

        public Builder withFlags(FileSystemFlags ... flags) {
            return this.withFlags(Arrays.asList(flags));
        }

        public Builder withFlags(Collection<FileSystemFlags> flags) {
            this.validate(flags);
            this.flags.clear();
            this.flags.addAll(flags);
            return this;
        }

        private void validate(Collection<FileSystemFlags> flags) {
            if (flags.contains((Object)FileSystemFlags.READONLY)) {
                if (flags.contains((Object)FileSystemFlags.INIT_IMPLICITLY)) {
                    throw new IllegalStateException("Can not set flag INIT_IMPLICITLY in conjunction with flag READONLY.");
                }
                if (flags.contains((Object)FileSystemFlags.MIGRATE_IMPLICITLY)) {
                    throw new IllegalStateException("Can not set flag MIGRATE_IMPLICITLY in conjunction with flag READONLY.");
                }
            }
        }

        @Deprecated
        public Builder withReadonlyFlag() {
            this.flags.add(FileSystemFlags.READONLY);
            this.flags.remove((Object)FileSystemFlags.INIT_IMPLICITLY);
            this.flags.remove((Object)FileSystemFlags.MIGRATE_IMPLICITLY);
            return this;
        }

        public Builder withMasterkeyFilename(String masterkeyFilename) {
            this.masterkeyFilename = masterkeyFilename;
            return this;
        }

        public CryptoFileSystemProperties build() {
            this.validate();
            return new CryptoFileSystemProperties(this);
        }

        private void validate() {
            if (this.passphrase == null) {
                throw new IllegalStateException("passphrase is required");
            }
            if (Strings.nullToEmpty((String)this.masterkeyFilename).trim().isEmpty()) {
                throw new IllegalStateException("masterkeyFilename is required");
            }
        }
    }

    public static enum FileSystemFlags {
        READONLY,
        MIGRATE_IMPLICITLY,
        INIT_IMPLICITLY;

    }
}

