/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemUri;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.DaggerCryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.FileSystemNeedsMigrationException;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.ch.AsyncDelegatingFileChannel;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.common.MasterkeyBackupFileHasher;
import org.cryptomator.cryptofs.migration.Migrators;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;

public class CryptoFileSystemProvider
extends FileSystemProvider {
    private static final CryptorProvider CRYPTOR_PROVIDER = Cryptors.version1((SecureRandom)CryptoFileSystemProvider.strongSecureRandom());
    private final CryptoFileSystems fileSystems;
    private final MoveOperation moveOperation;
    private final CopyOperation copyOperation;

    public CryptoFileSystemProvider() {
        this(DaggerCryptoFileSystemProviderComponent.builder().cryptorProvider(CRYPTOR_PROVIDER).build());
    }

    CryptoFileSystemProvider(CryptoFileSystemProviderComponent component) {
        this.fileSystems = component.fileSystems();
        this.moveOperation = component.moveOperation();
        this.copyOperation = component.copyOperation();
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", e);
        }
    }

    public static CryptoFileSystem newFileSystem(Path pathToVault, CryptoFileSystemProperties properties) throws FileSystemNeedsMigrationException, IOException {
        URI uri = CryptoFileSystemUri.create(pathToVault.toAbsolutePath(), new String[0]);
        return (CryptoFileSystem)FileSystems.newFileSystem(uri, properties);
    }

    public static void initialize(Path pathToVault, String masterkeyFilename, CharSequence passphrase) throws NotDirectoryException, IOException {
        CryptoFileSystemProvider.initialize(pathToVault, masterkeyFilename, new byte[0], passphrase);
    }

    public static void initialize(Path pathToVault, String masterkeyFilename, byte[] pepper, CharSequence passphrase) throws NotDirectoryException, IOException {
        if (!Files.isDirectory(pathToVault, new LinkOption[0])) {
            throw new NotDirectoryException(pathToVault.toString());
        }
        new FileSystemCapabilityChecker().checkCapabilities(pathToVault);
        try (Cryptor cryptor = CRYPTOR_PROVIDER.createNew();){
            Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
            byte[] keyFileContents = cryptor.writeKeysToMasterkeyFile((CharSequence)Normalizer.normalize(passphrase, Normalizer.Form.NFC), pepper, 7).serialize();
            Files.write(masterKeyPath, keyFileContents, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            String rootDirHash = cryptor.fileNameCryptor().hashDirectoryId("");
            Path rootDirPath = pathToVault.resolve("d").resolve(rootDirHash.substring(0, 2)).resolve(rootDirHash.substring(2));
            Files.createDirectories(rootDirPath, new FileAttribute[0]);
        }
        assert (CryptoFileSystemProvider.containsVault(pathToVault, masterkeyFilename));
    }

    public static boolean containsVault(Path pathToVault, String masterkeyFilename) {
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        Path dataDirPath = pathToVault.resolve("d");
        return Files.isReadable(masterKeyPath) && Files.isDirectory(dataDirPath, new LinkOption[0]);
    }

    public static void changePassphrase(Path pathToVault, String masterkeyFilename, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException, FileSystemNeedsMigrationException, IOException {
        CryptoFileSystemProvider.changePassphrase(pathToVault, masterkeyFilename, new byte[0], oldPassphrase, newPassphrase);
    }

    public static void changePassphrase(Path pathToVault, String masterkeyFilename, byte[] pepper, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException, FileSystemNeedsMigrationException, IOException {
        if (Migrators.get().needsMigration(pathToVault, masterkeyFilename)) {
            throw new FileSystemNeedsMigrationException(pathToVault);
        }
        String normalizedOldPassphrase = Normalizer.normalize(oldPassphrase, Normalizer.Form.NFC);
        String normalizedNewPassphrase = Normalizer.normalize(newPassphrase, Normalizer.Form.NFC);
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        byte[] oldMasterkeyBytes = Files.readAllBytes(masterKeyPath);
        byte[] newMasterkeyBytes = Cryptors.changePassphrase((CryptorProvider)CRYPTOR_PROVIDER, (byte[])oldMasterkeyBytes, (byte[])pepper, (CharSequence)normalizedOldPassphrase, (CharSequence)normalizedNewPassphrase);
        Path backupKeyPath = pathToVault.resolve(masterkeyFilename + MasterkeyBackupFileHasher.generateFileIdSuffix(oldMasterkeyBytes) + ".bkup");
        Files.move(masterKeyPath, backupKeyPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        Files.write(masterKeyPath, newMasterkeyBytes, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    public static byte[] exportRawKey(Path pathToVault, String masterkeyFilename, byte[] pepper, CharSequence passphrase) throws InvalidPassphraseException, IOException {
        String normalizedPassphrase = Normalizer.normalize(passphrase, Normalizer.Form.NFC);
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        byte[] masterKeyBytes = Files.readAllBytes(masterKeyPath);
        return Cryptors.exportRawKey((CryptorProvider)CRYPTOR_PROVIDER, (byte[])masterKeyBytes, (byte[])pepper, (CharSequence)normalizedPassphrase);
    }

    public static void restoreRawKey(Path pathToVault, String masterkeyFilename, byte[] rawKey, byte[] pepper, CharSequence passphrase) throws InvalidPassphraseException, IOException {
        String normalizedPassphrase = Normalizer.normalize(passphrase, Normalizer.Form.NFC);
        byte[] masterKeyBytes = Cryptors.restoreRawKey((CryptorProvider)CRYPTOR_PROVIDER, (byte[])rawKey, (byte[])pepper, (CharSequence)normalizedPassphrase, (int)7);
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        if (Files.exists(masterKeyPath, new LinkOption[0])) {
            byte[] oldMasterkeyBytes = Files.readAllBytes(masterKeyPath);
            Path backupKeyPath = pathToVault.resolve(masterkeyFilename + MasterkeyBackupFileHasher.generateFileIdSuffix(oldMasterkeyBytes) + ".bkup");
            Files.move(masterKeyPath, backupKeyPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        Files.write(masterKeyPath, masterKeyBytes, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    @Deprecated
    CryptoFileSystems getCryptoFileSystems() {
        return this.fileSystems;
    }

    @Override
    public String getScheme() {
        return "cryptomator";
    }

    @Override
    public CryptoFileSystem newFileSystem(URI uri, Map<String, ?> rawProperties) throws IOException {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        CryptoFileSystemProperties properties = CryptoFileSystemProperties.wrap(rawProperties);
        new FileSystemCapabilityChecker().checkCapabilities(parsedUri.pathToVault());
        this.initializeFileSystemIfRequired(parsedUri, properties);
        this.migrateFileSystemIfRequired(parsedUri, properties);
        return this.fileSystems.create(this, parsedUri.pathToVault(), properties);
    }

    @Deprecated
    private void migrateFileSystemIfRequired(CryptoFileSystemUri parsedUri, CryptoFileSystemProperties properties) throws IOException, FileSystemNeedsMigrationException {
        if (Migrators.get().needsMigration(parsedUri.pathToVault(), properties.masterkeyFilename())) {
            if (properties.migrateImplicitly()) {
                Migrators.get().migrate(parsedUri.pathToVault(), properties.masterkeyFilename(), properties.passphrase(), (state, progress) -> {});
            } else {
                throw new FileSystemNeedsMigrationException(parsedUri.pathToVault());
            }
        }
    }

    @Deprecated
    private void initializeFileSystemIfRequired(CryptoFileSystemUri parsedUri, CryptoFileSystemProperties properties) throws NotDirectoryException, IOException, NoSuchFileException {
        if (!CryptoFileSystemProvider.containsVault(parsedUri.pathToVault(), properties.masterkeyFilename())) {
            if (properties.initializeImplicitly()) {
                CryptoFileSystemProvider.initialize(parsedUri.pathToVault(), properties.masterkeyFilename(), properties.passphrase());
            } else {
                throw new NoSuchFileException(parsedUri.pathToVault().toString(), null, "Vault not initialized.");
            }
        }
    }

    @Override
    public CryptoFileSystem getFileSystem(URI uri) {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        return this.fileSystems.get(parsedUri.pathToVault());
    }

    @Override
    public Path getPath(URI uri) {
        CryptoFileSystemUri parsedUri = CryptoFileSystemUri.parse(uri);
        return this.fileSystems.get(parsedUri.pathToVault()).getPath(parsedUri.pathInsideVault(), new String[0]);
    }

    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path cleartextPath, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        if (options.contains(StandardOpenOption.APPEND)) {
            throw new IllegalArgumentException("AsynchronousFileChannel can not be opened in append mode");
        }
        return new AsyncDelegatingFileChannel(this.newFileChannel(cleartextPath, options, attrs), executor);
    }

    @Override
    public FileChannel newFileChannel(Path cleartextPath, Set<? extends OpenOption> optionsSet, FileAttribute<?> ... attrs) throws IOException {
        return this.fileSystem(cleartextPath).newFileChannel(CryptoPath.castAndAssertAbsolute(cleartextPath), optionsSet, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path cleartextPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.newFileChannel(cleartextPath, options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path cleartextDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fileSystem(cleartextDir).newDirectoryStream(CryptoPath.castAndAssertAbsolute(cleartextDir), filter);
    }

    @Override
    public void createDirectory(Path cleartextDir, FileAttribute<?> ... attrs) throws IOException {
        this.fileSystem(cleartextDir).createDirectory(CryptoPath.castAndAssertAbsolute(cleartextDir), attrs);
    }

    @Override
    public void delete(Path cleartextPath) throws IOException {
        this.fileSystem(cleartextPath).delete(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public void copy(Path cleartextSource, Path cleartextTarget, CopyOption ... options) throws IOException {
        this.assertSameProvider(cleartextSource);
        this.assertSameProvider(cleartextTarget);
        this.copyOperation.copy(CryptoPath.castAndAssertAbsolute(cleartextSource), CryptoPath.castAndAssertAbsolute(cleartextTarget), options);
    }

    @Override
    public void move(Path cleartextSource, Path cleartextTarget, CopyOption ... options) throws IOException {
        this.assertSameProvider(cleartextSource);
        this.assertSameProvider(cleartextTarget);
        this.moveOperation.move(CryptoPath.castAndAssertAbsolute(cleartextSource), CryptoPath.castAndAssertAbsolute(cleartextTarget), options);
    }

    @Override
    public boolean isSameFile(Path cleartextPath, Path cleartextPath2) throws IOException {
        return cleartextPath.getFileSystem() == cleartextPath2.getFileSystem() && cleartextPath.toRealPath(new LinkOption[0]).equals(cleartextPath2.toRealPath(new LinkOption[0]));
    }

    @Override
    public boolean isHidden(Path cleartextPath) throws IOException {
        return this.fileSystem(cleartextPath).isHidden(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public FileStore getFileStore(Path cleartextPath) throws IOException {
        return this.fileSystem(cleartextPath).getFileStore();
    }

    @Override
    public void checkAccess(Path cleartextPath, AccessMode ... modes) throws IOException {
        this.fileSystem(cleartextPath).checkAccess(CryptoPath.castAndAssertAbsolute(cleartextPath), modes);
    }

    @Override
    public void createSymbolicLink(Path cleartextPath, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.fileSystem(cleartextPath).createSymbolicLink(CryptoPath.castAndAssertAbsolute(cleartextPath), target, attrs);
    }

    @Override
    public Path readSymbolicLink(Path cleartextPath) throws IOException {
        return this.fileSystem(cleartextPath).readSymbolicLink(CryptoPath.castAndAssertAbsolute(cleartextPath));
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path cleartextPath, Class<V> type, LinkOption ... options) {
        return this.fileSystem(cleartextPath).getFileAttributeView(CryptoPath.castAndAssertAbsolute(cleartextPath), type, options);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path cleartextPath, Class<A> type, LinkOption ... options) throws IOException {
        return this.fileSystem(cleartextPath).readAttributes(CryptoPath.castAndAssertAbsolute(cleartextPath), type, options);
    }

    @Override
    public Map<String, Object> readAttributes(Path cleartextPath, String attributes, LinkOption ... options) throws IOException {
        return this.fileSystem(cleartextPath).readAttributes(CryptoPath.castAndAssertAbsolute(cleartextPath), attributes, options);
    }

    @Override
    public void setAttribute(Path cleartextPath, String attribute, Object value, LinkOption ... options) throws IOException {
        this.fileSystem(cleartextPath).setAttribute(CryptoPath.castAndAssertAbsolute(cleartextPath), attribute, value, options);
    }

    private CryptoFileSystemImpl fileSystem(Path path) {
        this.assertSameProvider(path);
        CryptoFileSystemImpl fs = CryptoPath.cast(path).getFileSystem();
        fs.assertOpen();
        return fs;
    }

    private void assertSameProvider(Path path) {
        if (path.getFileSystem().provider() != this) {
            throw new ProviderMismatchException("Used a path from provider " + path.getFileSystem().provider() + " with provider " + this);
        }
    }
}

