/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;

@CryptoFileSystemScoped
public class CryptoFileSystemStats {
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder bytesDecrypted = new LongAdder();
    private final LongAdder bytesEncrypted = new LongAdder();
    private final LongAdder chunkCacheAccesses = new LongAdder();
    private final LongAdder chunkCacheMisses = new LongAdder();
    private final LongAdder chunkCacheHits = new LongAdder();

    @Inject
    CryptoFileSystemStats() {
    }

    public long pollBytesRead() {
        return this.bytesRead.sumThenReset();
    }

    public void addBytesRead(long numBytes) {
        this.bytesRead.add(numBytes);
    }

    public long pollBytesWritten() {
        return this.bytesWritten.sumThenReset();
    }

    public void addBytesWritten(long numBytes) {
        this.bytesWritten.add(numBytes);
    }

    public long pollBytesDecrypted() {
        return this.bytesDecrypted.sumThenReset();
    }

    public void addBytesDecrypted(long numBytes) {
        this.bytesDecrypted.add(numBytes);
    }

    public long pollBytesEncrypted() {
        return this.bytesEncrypted.sumThenReset();
    }

    public void addBytesEncrypted(long numBytes) {
        this.bytesEncrypted.add(numBytes);
    }

    public long pollChunkCacheAccesses() {
        return this.chunkCacheAccesses.sumThenReset();
    }

    public void addChunkCacheAccess() {
        this.chunkCacheAccesses.increment();
        this.chunkCacheHits.increment();
    }

    public long pollChunkCacheHits() {
        return Math.max(0L, this.chunkCacheHits.sumThenReset());
    }

    public long pollChunkCacheMisses() {
        return this.chunkCacheMisses.sumThenReset();
    }

    public void addChunkCacheMiss() {
        this.chunkCacheMisses.increment();
        this.chunkCacheHits.decrement();
    }
}

