/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;

@Singleton
class CryptoFileSystems {
    private final CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent;
    private final ConcurrentMap<Path, CryptoFileSystemImpl> fileSystems = new ConcurrentHashMap<Path, CryptoFileSystemImpl>();

    @Inject
    public CryptoFileSystems(CryptoFileSystemProviderComponent cryptoFileSystemProviderComponent) {
        this.cryptoFileSystemProviderComponent = cryptoFileSystemProviderComponent;
    }

    public CryptoFileSystemImpl create(CryptoFileSystemProvider provider, Path pathToVault, CryptoFileSystemProperties properties) throws IOException {
        try {
            Path normalizedPathToVault = pathToVault.normalize();
            return this.fileSystems.compute(normalizedPathToVault, (key, value) -> {
                if (value == null) {
                    return this.cryptoFileSystemProviderComponent.newCryptoFileSystemComponent().pathToVault((Path)key).properties(properties).provider(provider).build().cryptoFileSystem();
                }
                throw new FileSystemAlreadyExistsException();
            });
        }
        catch (UncheckedIOException e) {
            throw new IOException("Error during file system creation.", e);
        }
    }

    public void remove(CryptoFileSystemImpl cryptoFileSystem) {
        this.fileSystems.values().remove(cryptoFileSystem);
    }

    public boolean contains(CryptoFileSystemImpl cryptoFileSystem) {
        return this.fileSystems.containsValue(cryptoFileSystem);
    }

    public CryptoFileSystemImpl get(Path pathToVault) {
        Path normalizedPathToVault = pathToVault.normalize();
        CryptoFileSystemImpl fs = (CryptoFileSystemImpl)this.fileSystems.get(normalizedPathToVault);
        if (fs == null) {
            throw new FileSystemNotFoundException(String.format("CryptoFileSystem at %s not initialized", pathToVault));
        }
        return fs;
    }
}

