/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Provider;
import org.cryptomator.cryptofs.CopyOperation;
import org.cryptomator.cryptofs.CopyOperation_Factory;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileStore_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemComponent;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemImpl_Factory;
import org.cryptomator.cryptofs.CryptoFileSystemModule;
import org.cryptomator.cryptofs.CryptoFileSystemModule_ProvideCryptorFactory;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemProviderComponent;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystemStats_Factory;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoFileSystems_Factory;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathFactory_Factory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.CryptoPathMapper_Factory;
import org.cryptomator.cryptofs.DirectoryIdLoader;
import org.cryptomator.cryptofs.DirectoryIdLoader_Factory;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.DirectoryIdProvider_Factory;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FilesWrapper;
import org.cryptomator.cryptofs.FilesWrapper_Factory;
import org.cryptomator.cryptofs.GlobToRegexConverter;
import org.cryptomator.cryptofs.GlobToRegexConverter_Factory;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.LongFileNameProvider_Factory;
import org.cryptomator.cryptofs.MoveOperation;
import org.cryptomator.cryptofs.MoveOperation_Factory;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathMatcherFactory_Factory;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.ReadonlyFlag_Factory;
import org.cryptomator.cryptofs.RootDirectoryInitializer;
import org.cryptomator.cryptofs.RootDirectoryInitializer_Factory;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.Symlinks_Factory;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.attr.AttributeViewModule_ProvideAttributeViewFactory;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider_Factory;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoFileOwnerAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributeView_Factory;
import org.cryptomator.cryptofs.ch.ChannelCloseListener;
import org.cryptomator.cryptofs.ch.ChannelComponent;
import org.cryptomator.cryptofs.ch.CleartextFileChannel;
import org.cryptomator.cryptofs.ch.CleartextFileChannel_Factory;
import org.cryptomator.cryptofs.common.FinallyUtil;
import org.cryptomator.cryptofs.common.FinallyUtil_Factory;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter_Factory;
import org.cryptomator.cryptofs.dir.C9rConflictResolver;
import org.cryptomator.cryptofs.dir.C9rConflictResolver_Factory;
import org.cryptomator.cryptofs.dir.C9rDecryptor;
import org.cryptomator.cryptofs.dir.C9rDecryptor_Factory;
import org.cryptomator.cryptofs.dir.C9rProcessor;
import org.cryptomator.cryptofs.dir.C9rProcessor_Factory;
import org.cryptomator.cryptofs.dir.C9sInflator;
import org.cryptomator.cryptofs.dir.C9sInflator_Factory;
import org.cryptomator.cryptofs.dir.C9sProcessor;
import org.cryptomator.cryptofs.dir.C9sProcessor_Factory;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter_Factory;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream_Factory;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory_Factory;
import org.cryptomator.cryptofs.dir.NodeProcessor;
import org.cryptomator.cryptofs.dir.NodeProcessor_Factory;
import org.cryptomator.cryptofs.fh.ChunkCache;
import org.cryptomator.cryptofs.fh.ChunkCache_Factory;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.ChunkIO_Factory;
import org.cryptomator.cryptofs.fh.ChunkLoader;
import org.cryptomator.cryptofs.fh.ChunkLoader_Factory;
import org.cryptomator.cryptofs.fh.ChunkSaver;
import org.cryptomator.cryptofs.fh.ChunkSaver_Factory;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite_Factory;
import org.cryptomator.cryptofs.fh.FileCloseListener;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.FileHeaderHolder_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideCurrentPathFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideFileSizeFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideLastModifiedDateFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideReadWriteLockFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles_Factory;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.FileHeader;

final class DaggerCryptoFileSystemProviderComponent
implements CryptoFileSystemProviderComponent {
    private Provider<CryptoFileSystemProviderComponent> cryptoFileSystemProviderComponentProvider;
    private Provider<CryptoFileSystems> cryptoFileSystemsProvider;
    private Provider<CopyOperation> copyOperationProvider;
    private Provider<MoveOperation> moveOperationProvider;
    private Provider<CryptorProvider> cryptorProvider2;
    private Provider<GlobToRegexConverter> globToRegexConverterProvider;
    private Provider<PathMatcherFactory> pathMatcherFactoryProvider;
    private Provider<FinallyUtil> finallyUtilProvider;
    private Provider<FilesWrapper> filesWrapperProvider;

    private DaggerCryptoFileSystemProviderComponent(CryptorProvider cryptorProviderParam) {
        this.initialize(cryptorProviderParam);
    }

    public static CryptoFileSystemProviderComponent.Builder builder() {
        return new Builder();
    }

    private void initialize(CryptorProvider cryptorProviderParam) {
        this.cryptoFileSystemProviderComponentProvider = InstanceFactory.create((Object)this);
        this.cryptoFileSystemsProvider = DoubleCheck.provider((Provider)CryptoFileSystems_Factory.create(this.cryptoFileSystemProviderComponentProvider));
        this.copyOperationProvider = DoubleCheck.provider((Provider)CopyOperation_Factory.create());
        this.moveOperationProvider = DoubleCheck.provider((Provider)MoveOperation_Factory.create(this.copyOperationProvider));
        this.cryptorProvider2 = InstanceFactory.create((Object)cryptorProviderParam);
        this.globToRegexConverterProvider = DoubleCheck.provider((Provider)GlobToRegexConverter_Factory.create());
        this.pathMatcherFactoryProvider = DoubleCheck.provider((Provider)PathMatcherFactory_Factory.create(this.globToRegexConverterProvider));
        this.finallyUtilProvider = DoubleCheck.provider((Provider)FinallyUtil_Factory.create());
        this.filesWrapperProvider = DoubleCheck.provider((Provider)FilesWrapper_Factory.create());
    }

    @Override
    public CryptoFileSystems fileSystems() {
        return (CryptoFileSystems)this.cryptoFileSystemsProvider.get();
    }

    @Override
    public MoveOperation moveOperation() {
        return (MoveOperation)this.moveOperationProvider.get();
    }

    @Override
    public CopyOperation copyOperation() {
        return (CopyOperation)this.copyOperationProvider.get();
    }

    @Override
    public CryptoFileSystemComponent.Builder newCryptoFileSystemComponent() {
        return new CryptoFileSystemComponentBuilder();
    }

    private final class CryptoFileSystemComponentImpl
    implements CryptoFileSystemComponent {
        private Provider<CryptoFileSystemProvider> providerProvider;
        private Provider<Path> pathToVaultProvider;
        private Provider<CryptoFileSystemProperties> propertiesProvider;
        private Provider<ReadonlyFlag> readonlyFlagProvider;
        private Provider<Cryptor> provideCryptorProvider;
        private Provider<CryptoFileStore> cryptoFileStoreProvider;
        private Provider<CryptoFileSystemStats> cryptoFileSystemStatsProvider;
        private Provider<DirectoryIdLoader> directoryIdLoaderProvider;
        private Provider<DirectoryIdProvider> directoryIdProvider;
        private Provider<LongFileNameProvider> longFileNameProvider;
        private Provider<CryptoPathMapper> cryptoPathMapperProvider;
        private Provider<OpenCryptoFileComponent.Builder> openCryptoFileComponentBuilderProvider;
        private Provider<OpenCryptoFiles> openCryptoFilesProvider;
        private Provider<Symlinks> symlinksProvider;
        private Provider<CryptoPathFactory> cryptoPathFactoryProvider;
        private Provider<DirectoryStreamComponent.Builder> directoryStreamComponentBuilderProvider;
        private Provider<DirectoryStreamFactory> directoryStreamFactoryProvider;
        private Provider<AttributeProvider> attributeProvider;
        private Provider<AttributeViewComponent.Builder> attributeViewComponentBuilderProvider;
        private Provider<AttributeViewProvider> attributeViewProvider;
        private Provider<AttributeByNameProvider> attributeByNameProvider;
        private Provider<CiphertextDirectoryDeleter> ciphertextDirectoryDeleterProvider;
        private Provider<RootDirectoryInitializer> rootDirectoryInitializerProvider;
        private Provider<CryptoFileSystemImpl> cryptoFileSystemImplProvider;

        private CryptoFileSystemComponentImpl(CryptoFileSystemModule cryptoFileSystemModuleParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties propertiesParam) {
            this.initialize(cryptoFileSystemModuleParam, providerParam, pathToVaultParam, propertiesParam);
        }

        private void initialize(CryptoFileSystemModule cryptoFileSystemModuleParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam, CryptoFileSystemProperties propertiesParam) {
            this.providerProvider = InstanceFactory.create((Object)providerParam);
            this.pathToVaultProvider = InstanceFactory.create((Object)pathToVaultParam);
            this.propertiesProvider = InstanceFactory.create((Object)propertiesParam);
            this.readonlyFlagProvider = DoubleCheck.provider((Provider)ReadonlyFlag_Factory.create(this.propertiesProvider, this.pathToVaultProvider));
            this.provideCryptorProvider = DoubleCheck.provider((Provider)CryptoFileSystemModule_ProvideCryptorFactory.create(cryptoFileSystemModuleParam, (Provider<CryptorProvider>)DaggerCryptoFileSystemProviderComponent.this.cryptorProvider2, this.pathToVaultProvider, this.propertiesProvider, this.readonlyFlagProvider));
            this.cryptoFileStoreProvider = DoubleCheck.provider((Provider)CryptoFileStore_Factory.create(this.pathToVaultProvider, this.readonlyFlagProvider));
            this.cryptoFileSystemStatsProvider = DoubleCheck.provider((Provider)CryptoFileSystemStats_Factory.create());
            this.directoryIdLoaderProvider = DoubleCheck.provider((Provider)DirectoryIdLoader_Factory.create());
            this.directoryIdProvider = DoubleCheck.provider((Provider)DirectoryIdProvider_Factory.create(this.directoryIdLoaderProvider));
            this.longFileNameProvider = DoubleCheck.provider((Provider)LongFileNameProvider_Factory.create(this.readonlyFlagProvider));
            this.cryptoPathMapperProvider = DoubleCheck.provider((Provider)CryptoPathMapper_Factory.create(this.pathToVaultProvider, this.provideCryptorProvider, this.directoryIdProvider, this.longFileNameProvider));
            this.openCryptoFileComponentBuilderProvider = new Provider<OpenCryptoFileComponent.Builder>(){

                public OpenCryptoFileComponent.Builder get() {
                    return new OpenCryptoFileComponentBuilder();
                }
            };
            this.openCryptoFilesProvider = DoubleCheck.provider((Provider)OpenCryptoFiles_Factory.create(this.openCryptoFileComponentBuilderProvider));
            this.symlinksProvider = DoubleCheck.provider((Provider)Symlinks_Factory.create(this.cryptoPathMapperProvider, this.longFileNameProvider, this.openCryptoFilesProvider, this.readonlyFlagProvider));
            this.cryptoPathFactoryProvider = DoubleCheck.provider((Provider)CryptoPathFactory_Factory.create(this.symlinksProvider));
            this.directoryStreamComponentBuilderProvider = new Provider<DirectoryStreamComponent.Builder>(){

                public DirectoryStreamComponent.Builder get() {
                    return new DirectoryStreamComponentBuilder();
                }
            };
            this.directoryStreamFactoryProvider = DoubleCheck.provider((Provider)DirectoryStreamFactory_Factory.create(this.cryptoPathMapperProvider, this.directoryStreamComponentBuilderProvider));
            this.attributeProvider = DoubleCheck.provider((Provider)AttributeProvider_Factory.create(this.provideCryptorProvider, this.cryptoPathMapperProvider, this.openCryptoFilesProvider, this.propertiesProvider, this.symlinksProvider));
            this.attributeViewComponentBuilderProvider = new Provider<AttributeViewComponent.Builder>(){

                public AttributeViewComponent.Builder get() {
                    return new AttributeViewComponentBuilder();
                }
            };
            this.attributeViewProvider = DoubleCheck.provider((Provider)AttributeViewProvider_Factory.create(this.attributeViewComponentBuilderProvider));
            this.attributeByNameProvider = DoubleCheck.provider((Provider)AttributeByNameProvider_Factory.create(this.attributeProvider, this.attributeViewProvider));
            this.ciphertextDirectoryDeleterProvider = DoubleCheck.provider((Provider)CiphertextDirectoryDeleter_Factory.create(this.directoryStreamFactoryProvider));
            this.rootDirectoryInitializerProvider = DoubleCheck.provider((Provider)RootDirectoryInitializer_Factory.create(this.cryptoPathMapperProvider, this.readonlyFlagProvider, (Provider<FilesWrapper>)DaggerCryptoFileSystemProviderComponent.this.filesWrapperProvider));
            this.cryptoFileSystemImplProvider = DoubleCheck.provider((Provider)CryptoFileSystemImpl_Factory.create(this.providerProvider, (Provider<CryptoFileSystems>)DaggerCryptoFileSystemProviderComponent.this.cryptoFileSystemsProvider, this.pathToVaultProvider, this.provideCryptorProvider, this.cryptoFileStoreProvider, this.cryptoFileSystemStatsProvider, this.cryptoPathMapperProvider, this.cryptoPathFactoryProvider, (Provider<PathMatcherFactory>)DaggerCryptoFileSystemProviderComponent.this.pathMatcherFactoryProvider, this.directoryStreamFactoryProvider, this.directoryIdProvider, this.attributeProvider, this.attributeByNameProvider, this.attributeViewProvider, this.openCryptoFilesProvider, this.symlinksProvider, (Provider<FinallyUtil>)DaggerCryptoFileSystemProviderComponent.this.finallyUtilProvider, this.ciphertextDirectoryDeleterProvider, this.readonlyFlagProvider, this.rootDirectoryInitializerProvider));
        }

        @Override
        public CryptoFileSystemImpl cryptoFileSystem() {
            return (CryptoFileSystemImpl)this.cryptoFileSystemImplProvider.get();
        }

        private final class AttributeViewComponentImpl
        implements AttributeViewComponent {
            private Provider<CryptoPath> cleartextPathProvider;
            private Provider<LinkOption[]> linkOptionsProvider;
            private Provider cryptoBasicFileAttributeViewProvider;
            private Provider cryptoPosixFileAttributeViewProvider;
            private Provider cryptoDosFileAttributeViewProvider;
            private Provider cryptoFileOwnerAttributeViewProvider;
            private Provider<Map<Class<?>, Provider<FileAttributeView>>> mapOfClassOfAndProviderOfFileAttributeViewProvider;
            private Provider<Class<? extends FileAttributeView>> viewTypeProvider;
            private Provider<Optional<FileAttributeView>> provideAttributeViewProvider;

            private AttributeViewComponentImpl(CryptoPath cleartextPathParam, Class<? extends FileAttributeView> viewTypeParam, LinkOption[] linkOptionsParam) {
                this.initialize(cleartextPathParam, viewTypeParam, linkOptionsParam);
            }

            private void initialize(CryptoPath cleartextPathParam, Class<? extends FileAttributeView> viewTypeParam, LinkOption[] linkOptionsParam) {
                this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
                this.linkOptionsProvider = InstanceFactory.create((Object)linkOptionsParam);
                this.cryptoBasicFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoBasicFileAttributeView_Factory.create(this.cleartextPathProvider, (Provider<CryptoPathMapper>)CryptoFileSystemComponentImpl.this.cryptoPathMapperProvider, this.linkOptionsProvider, (Provider<Symlinks>)CryptoFileSystemComponentImpl.this.symlinksProvider, (Provider<OpenCryptoFiles>)CryptoFileSystemComponentImpl.this.openCryptoFilesProvider, (Provider<AttributeProvider>)CryptoFileSystemComponentImpl.this.attributeProvider, (Provider<ReadonlyFlag>)CryptoFileSystemComponentImpl.this.readonlyFlagProvider));
                this.cryptoPosixFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoPosixFileAttributeView_Factory.create(this.cleartextPathProvider, (Provider<CryptoPathMapper>)CryptoFileSystemComponentImpl.this.cryptoPathMapperProvider, this.linkOptionsProvider, (Provider<Symlinks>)CryptoFileSystemComponentImpl.this.symlinksProvider, (Provider<OpenCryptoFiles>)CryptoFileSystemComponentImpl.this.openCryptoFilesProvider, (Provider<AttributeProvider>)CryptoFileSystemComponentImpl.this.attributeProvider, (Provider<ReadonlyFlag>)CryptoFileSystemComponentImpl.this.readonlyFlagProvider));
                this.cryptoDosFileAttributeViewProvider = DoubleCheck.provider((Provider)CryptoDosFileAttributeView_Factory.create(this.cleartextPathProvider, (Provider<CryptoPathMapper>)CryptoFileSystemComponentImpl.this.cryptoPathMapperProvider, this.linkOptionsProvider, (Provider<Symlinks>)CryptoFileSystemComponentImpl.this.symlinksProvider, (Provider<OpenCryptoFiles>)CryptoFileSystemComponentImpl.this.openCryptoFilesProvider, (Provider<AttributeProvider>)CryptoFileSystemComponentImpl.this.attributeProvider, (Provider<ReadonlyFlag>)CryptoFileSystemComponentImpl.this.readonlyFlagProvider));
                this.cryptoFileOwnerAttributeViewProvider = DoubleCheck.provider((Provider)CryptoFileOwnerAttributeView_Factory.create(this.cleartextPathProvider, (Provider<CryptoPathMapper>)CryptoFileSystemComponentImpl.this.cryptoPathMapperProvider, this.linkOptionsProvider, (Provider<Symlinks>)CryptoFileSystemComponentImpl.this.symlinksProvider, (Provider<OpenCryptoFiles>)CryptoFileSystemComponentImpl.this.openCryptoFilesProvider, (Provider<ReadonlyFlag>)CryptoFileSystemComponentImpl.this.readonlyFlagProvider));
                this.mapOfClassOfAndProviderOfFileAttributeViewProvider = MapProviderFactory.builder((int)4).put(BasicFileAttributeView.class, this.cryptoBasicFileAttributeViewProvider).put(PosixFileAttributeView.class, this.cryptoPosixFileAttributeViewProvider).put(DosFileAttributeView.class, this.cryptoDosFileAttributeViewProvider).put(FileOwnerAttributeView.class, this.cryptoFileOwnerAttributeViewProvider).build();
                this.viewTypeProvider = InstanceFactory.create(viewTypeParam);
                this.provideAttributeViewProvider = DoubleCheck.provider((Provider)AttributeViewModule_ProvideAttributeViewFactory.create(this.mapOfClassOfAndProviderOfFileAttributeViewProvider, this.viewTypeProvider));
            }

            @Override
            public Optional<FileAttributeView> attributeView() {
                return (Optional)this.provideAttributeViewProvider.get();
            }
        }

        private final class AttributeViewComponentBuilder
        implements AttributeViewComponent.Builder {
            private CryptoPath cleartextPath;
            private Class<? extends FileAttributeView> viewType;
            private LinkOption[] linkOptions;

            private AttributeViewComponentBuilder() {
            }

            @Override
            public AttributeViewComponentBuilder cleartextPath(CryptoPath cleartextPath) {
                this.cleartextPath = (CryptoPath)Preconditions.checkNotNull((Object)cleartextPath);
                return this;
            }

            @Override
            public AttributeViewComponentBuilder viewType(Class<? extends FileAttributeView> type) {
                this.viewType = (Class)Preconditions.checkNotNull(type);
                return this;
            }

            @Override
            public AttributeViewComponentBuilder linkOptions(LinkOption[] linkOptions) {
                this.linkOptions = (LinkOption[])Preconditions.checkNotNull((Object)linkOptions);
                return this;
            }

            @Override
            public AttributeViewComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.cleartextPath, CryptoPath.class);
                Preconditions.checkBuilderRequirement(this.viewType, Class.class);
                Preconditions.checkBuilderRequirement((Object)this.linkOptions, LinkOption[].class);
                return new AttributeViewComponentImpl(this.cleartextPath, this.viewType, this.linkOptions);
            }
        }

        private final class DirectoryStreamComponentImpl
        implements DirectoryStreamComponent {
            private Provider<String> dirIdProvider;
            private Provider<DirectoryStream<Path>> ciphertextDirectoryStreamProvider;
            private Provider<Path> cleartextPathProvider;
            private Provider<DirectoryStream.Filter<? super Path>> filterProvider;
            private Provider<Consumer<CryptoDirectoryStream>> onCloseProvider;
            private Provider c9rDecryptorProvider;
            private Provider c9rConflictResolverProvider;
            private Provider c9rProcessorProvider;
            private Provider c9sInflatorProvider;
            private Provider c9sProcessorProvider;
            private Provider brokenDirectoryFilterProvider;
            private Provider nodeProcessorProvider;
            private Provider<CryptoDirectoryStream> cryptoDirectoryStreamProvider;

            private DirectoryStreamComponentImpl(Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
                this.initialize(cleartextPathParam, dirIdParam, ciphertextDirectoryStreamParam, filterParam, onCloseParam);
            }

            private void initialize(Path cleartextPathParam, String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam, DirectoryStream.Filter<? super Path> filterParam, Consumer<CryptoDirectoryStream> onCloseParam) {
                this.dirIdProvider = InstanceFactory.create((Object)dirIdParam);
                this.ciphertextDirectoryStreamProvider = InstanceFactory.create(ciphertextDirectoryStreamParam);
                this.cleartextPathProvider = InstanceFactory.create((Object)cleartextPathParam);
                this.filterProvider = InstanceFactory.create(filterParam);
                this.onCloseProvider = InstanceFactory.create(onCloseParam);
                this.c9rDecryptorProvider = DoubleCheck.provider((Provider)C9rDecryptor_Factory.create((Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.dirIdProvider));
                this.c9rConflictResolverProvider = DoubleCheck.provider((Provider)C9rConflictResolver_Factory.create((Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.dirIdProvider));
                this.c9rProcessorProvider = DoubleCheck.provider((Provider)C9rProcessor_Factory.create((Provider<C9rDecryptor>)this.c9rDecryptorProvider, (Provider<C9rConflictResolver>)this.c9rConflictResolverProvider));
                this.c9sInflatorProvider = DoubleCheck.provider((Provider)C9sInflator_Factory.create((Provider<LongFileNameProvider>)CryptoFileSystemComponentImpl.this.longFileNameProvider, (Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.dirIdProvider));
                this.c9sProcessorProvider = DoubleCheck.provider((Provider)C9sProcessor_Factory.create((Provider<C9sInflator>)this.c9sInflatorProvider));
                this.brokenDirectoryFilterProvider = DoubleCheck.provider((Provider)BrokenDirectoryFilter_Factory.create((Provider<CryptoPathMapper>)CryptoFileSystemComponentImpl.this.cryptoPathMapperProvider));
                this.nodeProcessorProvider = DoubleCheck.provider((Provider)NodeProcessor_Factory.create((Provider<C9rProcessor>)this.c9rProcessorProvider, (Provider<C9sProcessor>)this.c9sProcessorProvider, (Provider<BrokenDirectoryFilter>)this.brokenDirectoryFilterProvider));
                this.cryptoDirectoryStreamProvider = DoubleCheck.provider((Provider)CryptoDirectoryStream_Factory.create(this.dirIdProvider, this.ciphertextDirectoryStreamProvider, this.cleartextPathProvider, this.filterProvider, this.onCloseProvider, (Provider<NodeProcessor>)this.nodeProcessorProvider));
            }

            @Override
            public CryptoDirectoryStream directoryStream() {
                return (CryptoDirectoryStream)this.cryptoDirectoryStreamProvider.get();
            }
        }

        private final class DirectoryStreamComponentBuilder
        implements DirectoryStreamComponent.Builder {
            private Path cleartextPath;
            private String dirId;
            private DirectoryStream<Path> ciphertextDirectoryStream;
            private DirectoryStream.Filter<? super Path> filter;
            private Consumer<CryptoDirectoryStream> onClose;

            private DirectoryStreamComponentBuilder() {
            }

            @Override
            public DirectoryStreamComponentBuilder cleartextPath(Path cleartextPath) {
                this.cleartextPath = (Path)Preconditions.checkNotNull((Object)cleartextPath);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder dirId(String dirId) {
                this.dirId = (String)Preconditions.checkNotNull((Object)dirId);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder ciphertextDirectoryStream(DirectoryStream<Path> ciphertextDirectoryStream) {
                this.ciphertextDirectoryStream = (DirectoryStream)Preconditions.checkNotNull(ciphertextDirectoryStream);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder filter(DirectoryStream.Filter<? super Path> filter) {
                this.filter = (DirectoryStream.Filter)Preconditions.checkNotNull(filter);
                return this;
            }

            @Override
            public DirectoryStreamComponentBuilder onClose(Consumer<CryptoDirectoryStream> onClose) {
                this.onClose = (Consumer)Preconditions.checkNotNull(onClose);
                return this;
            }

            @Override
            public DirectoryStreamComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.cleartextPath, Path.class);
                Preconditions.checkBuilderRequirement((Object)this.dirId, String.class);
                Preconditions.checkBuilderRequirement(this.ciphertextDirectoryStream, DirectoryStream.class);
                Preconditions.checkBuilderRequirement(this.filter, DirectoryStream.Filter.class);
                Preconditions.checkBuilderRequirement(this.onClose, Consumer.class);
                return new DirectoryStreamComponentImpl(this.cleartextPath, this.dirId, this.ciphertextDirectoryStream, this.filter, this.onClose);
            }
        }

        private final class OpenCryptoFileComponentImpl
        implements OpenCryptoFileComponent {
            private Provider<FileCloseListener> onCloseProvider;
            private Provider chunkIOProvider;
            private Provider<Path> pathProvider;
            private Provider<AtomicReference<Path>> provideCurrentPathProvider;
            private Provider<FileHeaderHolder> fileHeaderHolderProvider;
            private Provider chunkLoaderProvider;
            private Provider<ExceptionsDuringWrite> exceptionsDuringWriteProvider;
            private Provider chunkSaverProvider;
            private Provider<ChunkCache> chunkCacheProvider;
            private Provider<AtomicLong> provideFileSizeProvider;
            private Provider<AtomicReference<Instant>> provideLastModifiedDateProvider;
            private Provider<OpenCryptoFileComponent> openCryptoFileComponentProvider;
            private Provider<OpenCryptoFile> openCryptoFileProvider;
            private Provider<ReadWriteLock> provideReadWriteLockProvider;
            private Provider<Supplier<BasicFileAttributeView>> provideBasicFileAttributeViewSupplierProvider;

            private OpenCryptoFileComponentImpl(OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseParam) {
                this.initialize(openCryptoFileModuleParam, pathParam, onCloseParam);
            }

            private void initialize(OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam, FileCloseListener onCloseParam) {
                this.onCloseProvider = InstanceFactory.create((Object)onCloseParam);
                this.chunkIOProvider = DoubleCheck.provider((Provider)ChunkIO_Factory.create());
                this.pathProvider = InstanceFactory.create((Object)pathParam);
                this.provideCurrentPathProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideCurrentPathFactory.create(openCryptoFileModuleParam, this.pathProvider));
                this.fileHeaderHolderProvider = DoubleCheck.provider((Provider)FileHeaderHolder_Factory.create((Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.provideCurrentPathProvider));
                this.chunkLoaderProvider = DoubleCheck.provider((Provider)ChunkLoader_Factory.create((Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, (Provider<CryptoFileSystemStats>)CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.exceptionsDuringWriteProvider = DoubleCheck.provider((Provider)ExceptionsDuringWrite_Factory.create());
                this.chunkSaverProvider = DoubleCheck.provider((Provider)ChunkSaver_Factory.create((Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.fileHeaderHolderProvider, this.exceptionsDuringWriteProvider, (Provider<CryptoFileSystemStats>)CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.chunkCacheProvider = DoubleCheck.provider((Provider)ChunkCache_Factory.create((Provider<ChunkLoader>)this.chunkLoaderProvider, (Provider<ChunkSaver>)this.chunkSaverProvider, (Provider<CryptoFileSystemStats>)CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                this.provideFileSizeProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideFileSizeFactory.create(openCryptoFileModuleParam));
                this.provideLastModifiedDateProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideLastModifiedDateFactory.create(openCryptoFileModuleParam, this.pathProvider));
                this.openCryptoFileComponentProvider = InstanceFactory.create((Object)this);
                this.openCryptoFileProvider = DoubleCheck.provider((Provider)OpenCryptoFile_Factory.create(this.onCloseProvider, this.chunkCacheProvider, (Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, this.fileHeaderHolderProvider, (Provider<ChunkIO>)this.chunkIOProvider, this.provideCurrentPathProvider, this.provideFileSizeProvider, this.provideLastModifiedDateProvider, this.openCryptoFileComponentProvider));
                this.provideReadWriteLockProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideReadWriteLockFactory.create(openCryptoFileModuleParam));
                this.provideBasicFileAttributeViewSupplierProvider = DoubleCheck.provider((Provider)OpenCryptoFileModule_ProvideBasicFileAttributeViewSupplierFactory.create(openCryptoFileModuleParam, this.provideCurrentPathProvider));
            }

            @Override
            public OpenCryptoFile openCryptoFile() {
                return (OpenCryptoFile)this.openCryptoFileProvider.get();
            }

            @Override
            public ChannelComponent.Builder newChannelComponent() {
                return new ChannelComponentBuilder();
            }

            private final class ChannelComponentImpl
            implements ChannelComponent {
                private Provider<FileChannel> ciphertextChannelProvider;
                private Provider<FileHeader> fileHeaderProvider;
                private Provider<Boolean> mustWriteHeaderProvider;
                private Provider<EffectiveOpenOptions> openOptionsProvider;
                private Provider<ChannelCloseListener> onCloseProvider;
                private Provider<CleartextFileChannel> cleartextFileChannelProvider;

                private ChannelComponentImpl(EffectiveOpenOptions openOptionsParam, ChannelCloseListener onCloseParam, FileChannel ciphertextChannelParam, Boolean mustWriteHeaderParam, FileHeader fileHeaderParam) {
                    this.initialize(openOptionsParam, onCloseParam, ciphertextChannelParam, mustWriteHeaderParam, fileHeaderParam);
                }

                private void initialize(EffectiveOpenOptions openOptionsParam, ChannelCloseListener onCloseParam, FileChannel ciphertextChannelParam, Boolean mustWriteHeaderParam, FileHeader fileHeaderParam) {
                    this.ciphertextChannelProvider = InstanceFactory.create((Object)ciphertextChannelParam);
                    this.fileHeaderProvider = InstanceFactory.create((Object)fileHeaderParam);
                    this.mustWriteHeaderProvider = InstanceFactory.create((Object)mustWriteHeaderParam);
                    this.openOptionsProvider = InstanceFactory.create((Object)openOptionsParam);
                    this.onCloseProvider = InstanceFactory.create((Object)onCloseParam);
                    this.cleartextFileChannelProvider = DoubleCheck.provider((Provider)CleartextFileChannel_Factory.create(this.ciphertextChannelProvider, this.fileHeaderProvider, this.mustWriteHeaderProvider, (Provider<ReadWriteLock>)OpenCryptoFileComponentImpl.this.provideReadWriteLockProvider, (Provider<Cryptor>)CryptoFileSystemComponentImpl.this.provideCryptorProvider, (Provider<ChunkCache>)OpenCryptoFileComponentImpl.this.chunkCacheProvider, this.openOptionsProvider, (Provider<AtomicLong>)OpenCryptoFileComponentImpl.this.provideFileSizeProvider, (Provider<AtomicReference<Instant>>)OpenCryptoFileComponentImpl.this.provideLastModifiedDateProvider, (Provider<Supplier<BasicFileAttributeView>>)OpenCryptoFileComponentImpl.this.provideBasicFileAttributeViewSupplierProvider, (Provider<ExceptionsDuringWrite>)OpenCryptoFileComponentImpl.this.exceptionsDuringWriteProvider, this.onCloseProvider, (Provider<CryptoFileSystemStats>)CryptoFileSystemComponentImpl.this.cryptoFileSystemStatsProvider));
                }

                @Override
                public CleartextFileChannel channel() {
                    return (CleartextFileChannel)this.cleartextFileChannelProvider.get();
                }
            }

            private final class ChannelComponentBuilder
            implements ChannelComponent.Builder {
                private EffectiveOpenOptions openOptions;
                private ChannelCloseListener onClose;
                private FileChannel ciphertextChannel;
                private Boolean mustWriteHeader;
                private FileHeader fileHeader;

                private ChannelComponentBuilder() {
                }

                @Override
                public ChannelComponentBuilder openOptions(EffectiveOpenOptions options) {
                    this.openOptions = (EffectiveOpenOptions)Preconditions.checkNotNull((Object)options);
                    return this;
                }

                @Override
                public ChannelComponentBuilder onClose(ChannelCloseListener listener) {
                    this.onClose = (ChannelCloseListener)Preconditions.checkNotNull((Object)listener);
                    return this;
                }

                @Override
                public ChannelComponentBuilder ciphertextChannel(FileChannel ciphertextChannel) {
                    this.ciphertextChannel = (FileChannel)Preconditions.checkNotNull((Object)ciphertextChannel);
                    return this;
                }

                @Override
                public ChannelComponentBuilder mustWriteHeader(boolean mustWriteHeader) {
                    this.mustWriteHeader = (Boolean)Preconditions.checkNotNull((Object)mustWriteHeader);
                    return this;
                }

                @Override
                public ChannelComponentBuilder fileHeader(FileHeader fileHeader) {
                    this.fileHeader = (FileHeader)Preconditions.checkNotNull((Object)fileHeader);
                    return this;
                }

                @Override
                public ChannelComponent build() {
                    Preconditions.checkBuilderRequirement((Object)this.openOptions, EffectiveOpenOptions.class);
                    Preconditions.checkBuilderRequirement((Object)this.onClose, ChannelCloseListener.class);
                    Preconditions.checkBuilderRequirement((Object)this.ciphertextChannel, FileChannel.class);
                    Preconditions.checkBuilderRequirement((Object)this.mustWriteHeader, Boolean.class);
                    Preconditions.checkBuilderRequirement((Object)this.fileHeader, FileHeader.class);
                    return new ChannelComponentImpl(this.openOptions, this.onClose, this.ciphertextChannel, this.mustWriteHeader, this.fileHeader);
                }
            }
        }

        private final class OpenCryptoFileComponentBuilder
        implements OpenCryptoFileComponent.Builder {
            private Path path;
            private FileCloseListener onClose;

            private OpenCryptoFileComponentBuilder() {
            }

            @Override
            public OpenCryptoFileComponentBuilder path(Path path) {
                this.path = (Path)Preconditions.checkNotNull((Object)path);
                return this;
            }

            @Override
            public OpenCryptoFileComponentBuilder onClose(FileCloseListener listener) {
                this.onClose = (FileCloseListener)Preconditions.checkNotNull((Object)listener);
                return this;
            }

            @Override
            public OpenCryptoFileComponent build() {
                Preconditions.checkBuilderRequirement((Object)this.path, Path.class);
                Preconditions.checkBuilderRequirement((Object)this.onClose, FileCloseListener.class);
                return new OpenCryptoFileComponentImpl(new OpenCryptoFileModule(), this.path, this.onClose);
            }
        }
    }

    private final class CryptoFileSystemComponentBuilder
    implements CryptoFileSystemComponent.Builder {
        private CryptoFileSystemProvider provider;
        private Path pathToVault;
        private CryptoFileSystemProperties properties;

        private CryptoFileSystemComponentBuilder() {
        }

        @Override
        public CryptoFileSystemComponentBuilder provider(CryptoFileSystemProvider provider) {
            this.provider = (CryptoFileSystemProvider)Preconditions.checkNotNull((Object)provider);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder pathToVault(Path pathToVault) {
            this.pathToVault = (Path)Preconditions.checkNotNull((Object)pathToVault);
            return this;
        }

        @Override
        public CryptoFileSystemComponentBuilder properties(CryptoFileSystemProperties cryptoFileSystemProperties) {
            this.properties = (CryptoFileSystemProperties)Preconditions.checkNotNull((Object)cryptoFileSystemProperties);
            return this;
        }

        @Override
        public CryptoFileSystemComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.provider, CryptoFileSystemProvider.class);
            Preconditions.checkBuilderRequirement((Object)this.pathToVault, Path.class);
            Preconditions.checkBuilderRequirement((Object)this.properties, CryptoFileSystemProperties.class);
            return new CryptoFileSystemComponentImpl(new CryptoFileSystemModule(), this.provider, this.pathToVault, this.properties);
        }
    }

    private static final class Builder
    implements CryptoFileSystemProviderComponent.Builder {
        private CryptorProvider cryptorProvider;

        private Builder() {
        }

        @Override
        public Builder cryptorProvider(CryptorProvider cryptorProvider) {
            this.cryptorProvider = (CryptorProvider)Preconditions.checkNotNull((Object)cryptorProvider);
            return this;
        }

        @Override
        public CryptoFileSystemProviderComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.cryptorProvider, CryptorProvider.class);
            return new DaggerCryptoFileSystemProviderComponent(this.cryptorProvider);
        }
    }
}

