/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.Objects;

class DelegatingFileStore
extends FileStore {
    private final FileStore delegate;

    public DelegatingFileStore(FileStore delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public String name() {
        return this.type() + "_" + this.delegate.name();
    }

    @Override
    public String type() {
        return this.getClass().getSimpleName();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.delegate.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.delegate.getUsableSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.delegate.getUnallocatedSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return this.delegate.supportsFileAttributeView(type);
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return this.delegate.supportsFileAttributeView(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        throw new UnsupportedOperationException();
    }
}

