/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.cache.CacheLoader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;

@CryptoFileSystemScoped
class DirectoryIdLoader
extends CacheLoader<Path, String> {
    private static final int MAX_DIR_ID_LENGTH = 1000;

    @Inject
    public DirectoryIdLoader() {
    }

    public String load(Path dirFilePath) throws IOException {
        String string;
        block12: {
            FileChannel ch = FileChannel.open(dirFilePath, StandardOpenOption.READ);
            try {
                long size = ch.size();
                if (size == 0L) {
                    throw new IOException("Invalid, empty directory file: " + dirFilePath);
                }
                if (size > 1000L) {
                    throw new IOException("Unexpectedly large directory file: " + dirFilePath);
                }
                assert (size <= 1000L);
                ByteBuffer buffer = ByteBuffer.allocate((int)size);
                int read = ch.read(buffer);
                assert ((long)read == size);
                buffer.flip();
                string = StandardCharsets.UTF_8.decode(buffer).toString();
                if (ch == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (ch != null) {
                        try {
                            ch.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return UUID.randomUUID().toString();
                }
            }
            ch.close();
        }
        return string;
    }
}

