/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.PathToVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CryptoFileSystemScoped
public class ReadonlyFlag {
    private static final Logger LOG = LoggerFactory.getLogger(ReadonlyFlag.class);
    private final boolean readonly;

    @Inject
    public ReadonlyFlag(CryptoFileSystemProperties properties, @PathToVault Path pathToVault) {
        if (properties.readonly()) {
            LOG.info("Vault opened readonly.");
            this.readonly = true;
        } else if (!Files.isWritable(pathToVault)) {
            LOG.warn("Vault directory is write-protected.");
            this.readonly = true;
        } else {
            LOG.debug("Vault opened for read and write.");
            this.readonly = false;
        }
    }

    public void assertWritable() throws ReadOnlyFileSystemException {
        if (this.readonly) {
            throw new ReadOnlyFileSystemException();
        }
    }

    public boolean isSet() {
        return this.readonly;
    }
}

