/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.FilesWrapper;
import org.cryptomator.cryptofs.ReadonlyFlag;

@CryptoFileSystemScoped
class RootDirectoryInitializer {
    private final CryptoPathMapper cryptoPathMapper;
    private final ReadonlyFlag readonlyFlag;
    private final FilesWrapper files;

    @Inject
    public RootDirectoryInitializer(CryptoPathMapper cryptoPathMapper, ReadonlyFlag readonlyFlag, FilesWrapper files) {
        this.cryptoPathMapper = cryptoPathMapper;
        this.readonlyFlag = readonlyFlag;
        this.files = files;
    }

    public void initialize(CryptoPath cleartextRoot) {
        if (this.readonlyFlag.isSet()) {
            return;
        }
        try {
            Path ciphertextRoot = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextRoot).path;
            this.files.createDirectories(ciphertextRoot, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

