/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttributeView;
import java.util.Optional;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.common.ArrayUtils;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

abstract class AbstractCryptoFileAttributeView
implements FileAttributeView {
    protected final CryptoPath cleartextPath;
    private final CryptoPathMapper pathMapper;
    protected final LinkOption[] linkOptions;
    private final Symlinks symlinks;
    private final OpenCryptoFiles openCryptoFiles;

    public AbstractCryptoFileAttributeView(CryptoPath cleartextPath, CryptoPathMapper pathMapper, LinkOption[] linkOptions, Symlinks symlinks, OpenCryptoFiles openCryptoFiles) {
        this.cleartextPath = cleartextPath;
        this.pathMapper = pathMapper;
        this.linkOptions = linkOptions;
        this.symlinks = symlinks;
        this.openCryptoFiles = openCryptoFiles;
    }

    protected <T extends FileAttributeView> T getCiphertextAttributeView(Class<T> delegateType) throws IOException {
        Path ciphertextPath = this.getCiphertextPath(this.cleartextPath);
        return ciphertextPath.getFileSystem().provider().getFileAttributeView(ciphertextPath, delegateType, new LinkOption[0]);
    }

    protected Optional<OpenCryptoFile> getOpenCryptoFile() throws IOException {
        Path ciphertextPath = this.getCiphertextPath(this.cleartextPath);
        return this.openCryptoFiles.get(ciphertextPath);
    }

    private Path getCiphertextPath(CryptoPath path) throws IOException {
        CiphertextFileType type = this.pathMapper.getCiphertextFileType(path);
        switch (type) {
            case SYMLINK: {
                if (ArrayUtils.contains(this.linkOptions, LinkOption.NOFOLLOW_LINKS)) {
                    return this.pathMapper.getCiphertextFilePath(path).getSymlinkFilePath();
                }
                CryptoPath resolved = this.symlinks.resolveRecursively(path);
                return this.getCiphertextPath(resolved);
            }
            case DIRECTORY: {
                return this.pathMapper.getCiphertextDir((CryptoPath)path).path;
            }
        }
        return this.pathMapper.getCiphertextFilePath(path).getFilePath();
    }
}

