/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;

@CryptoFileSystemScoped
public class AttributeByNameProvider {
    private static final SortedMap<String, AttributeGetterImpl<?>> GETTERS = new TreeMap();
    private static final SortedMap<String, AttributeSetterImpl<?, ?>> SETTERS = new TreeMap();
    private final AttributeProvider attributeProvider;
    private final AttributeViewProvider attributeViewProvider;

    private static <T extends BasicFileAttributes> void getter(String name, Class<T> type, AttributeGetter<T> getter) {
        String plainName = name.substring(name.indexOf(58) + 1);
        GETTERS.put(name, AttributeGetter.getter(plainName, type, getter));
    }

    private static <T extends BasicFileAttributeView, V> void setter(String name, Class<T> type, Class<V> valueType, AttributeSetter<T, V> setter) {
        SETTERS.put(name, AttributeSetter.setter(type, valueType, setter));
    }

    @Inject
    AttributeByNameProvider(AttributeProvider attributeProvider, AttributeViewProvider attributeViewProvider) {
        this.attributeProvider = attributeProvider;
        this.attributeViewProvider = attributeViewProvider;
    }

    public void setAttribute(CryptoPath cleartextPath, String attributeName, Object value, LinkOption ... options) throws IOException {
        String normalizedAttributeName = this.normalizedAttributeName(attributeName);
        AttributeSetterImpl setter = (AttributeSetterImpl)SETTERS.get(normalizedAttributeName);
        if (setter == null) {
            throw new IllegalArgumentException("Unrecognized attribute name: " + attributeName);
        }
        Object view = this.attributeViewProvider.getAttributeView(cleartextPath, setter.type(), options);
        setter.set(view, value);
    }

    public Map<String, Object> readAttributes(CryptoPath cleartextPath, String attributesString, LinkOption ... options) throws IOException {
        if (attributesString.isEmpty()) {
            throw new IllegalArgumentException("No attributes specified");
        }
        Predicate<String> getterNameFilter = this.getterNameFilter(attributesString);
        Collection getters = GETTERS.entrySet().stream().filter(entry -> getterNameFilter.apply((Object)((String)entry.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
        return this.readAttributes(cleartextPath, getters, options);
    }

    private Map<String, Object> readAttributes(CryptoPath cleartextPath, Collection<AttributeGetterImpl> getters, LinkOption ... options) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object attributes = null;
        for (AttributeGetterImpl getter : getters) {
            if (attributes == null) {
                attributes = this.attributeProvider.readAttributes(cleartextPath, getter.type(), options);
            }
            String name = getter.name();
            result.put(name, getter.read(attributes));
        }
        return result;
    }

    private String normalizedAttributeName(String attributeName) {
        if (attributeName.indexOf(58) == -1) {
            return "basic:" + attributeName;
        }
        return attributeName;
    }

    private Predicate<String> getterNameFilter(String attributesString) {
        String viewName = this.viewName(attributesString);
        Set<String> attributeNames = this.attributeNames(viewName, attributesString);
        if (attributeNames.contains("*")) {
            String prefix = viewName + ":";
            return value -> value.startsWith(prefix);
        }
        return attributeNames::contains;
    }

    private String viewName(String attributes) {
        int firstColon = attributes.indexOf(58);
        if (firstColon == -1) {
            return "basic";
        }
        return attributes.substring(0, firstColon);
    }

    private Set<String> attributeNames(String viewName, String attributeString) {
        int firstColon = attributeString.indexOf(58);
        String attributeNames = firstColon == -1 ? attributeString : attributeString.substring(firstColon + 1);
        return Arrays.stream(attributeNames.split(",")).map(name -> {
            if ("*".equals(name)) {
                return "*";
            }
            return viewName + ":" + name;
        }).collect(Collectors.toSet());
    }

    static {
        AttributeByNameProvider.getter("basic:lastModifiedTime", BasicFileAttributes.class, BasicFileAttributes::lastModifiedTime);
        AttributeByNameProvider.getter("basic:lastAccessTime", BasicFileAttributes.class, BasicFileAttributes::lastAccessTime);
        AttributeByNameProvider.getter("basic:creationTime", BasicFileAttributes.class, BasicFileAttributes::creationTime);
        AttributeByNameProvider.getter("basic:isRegularFile", BasicFileAttributes.class, BasicFileAttributes::isRegularFile);
        AttributeByNameProvider.getter("basic:isDirectory", BasicFileAttributes.class, BasicFileAttributes::isDirectory);
        AttributeByNameProvider.getter("basic:isSymbolicLink", BasicFileAttributes.class, BasicFileAttributes::isSymbolicLink);
        AttributeByNameProvider.getter("basic:isOther", BasicFileAttributes.class, BasicFileAttributes::isOther);
        AttributeByNameProvider.getter("basic:size", BasicFileAttributes.class, BasicFileAttributes::size);
        AttributeByNameProvider.getter("basic:fileKey", BasicFileAttributes.class, BasicFileAttributes::fileKey);
        AttributeByNameProvider.getter("dos:readOnly", DosFileAttributes.class, DosFileAttributes::isReadOnly);
        AttributeByNameProvider.getter("dos:hidden", DosFileAttributes.class, DosFileAttributes::isHidden);
        AttributeByNameProvider.getter("dos:archive", DosFileAttributes.class, DosFileAttributes::isArchive);
        AttributeByNameProvider.getter("dos:system", DosFileAttributes.class, DosFileAttributes::isSystem);
        AttributeByNameProvider.getter("posix:owner", PosixFileAttributes.class, PosixFileAttributes::owner);
        AttributeByNameProvider.getter("posix:group", PosixFileAttributes.class, PosixFileAttributes::group);
        AttributeByNameProvider.getter("posix:permissions", PosixFileAttributes.class, PosixFileAttributes::permissions);
        AttributeByNameProvider.setter("basic:lastModifiedTime", BasicFileAttributeView.class, FileTime.class, (view, lastModifiedTime) -> view.setTimes((FileTime)lastModifiedTime, null, null));
        AttributeByNameProvider.setter("basic:lastAccessTime", BasicFileAttributeView.class, FileTime.class, (view, lastAccessTime) -> view.setTimes(null, (FileTime)lastAccessTime, null));
        AttributeByNameProvider.setter("basic:creationTime", BasicFileAttributeView.class, FileTime.class, (view, creationTime) -> view.setTimes(null, null, (FileTime)creationTime));
        AttributeByNameProvider.setter("dos:readOnly", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setReadOnly);
        AttributeByNameProvider.setter("dos:hidden", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setHidden);
        AttributeByNameProvider.setter("dos:archive", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setArchive);
        AttributeByNameProvider.setter("dos:system", DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setSystem);
        AttributeByNameProvider.setter("posix:owner", PosixFileAttributeView.class, UserPrincipal.class, FileOwnerAttributeView::setOwner);
        AttributeByNameProvider.setter("posix:group", PosixFileAttributeView.class, GroupPrincipal.class, PosixFileAttributeView::setGroup);
        AttributeByNameProvider.setter("posix:permissions", PosixFileAttributeView.class, Set.class, PosixFileAttributeView::setPermissions);
    }

    private static class AttributeGetterImpl<T extends BasicFileAttributes>
    implements AttributeGetter<T> {
        private final String name;
        private final Class<T> type;
        private final AttributeGetter<T> getter;

        private AttributeGetterImpl(String name, Class<T> type, AttributeGetter<T> getter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
        }

        public String name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        @Override
        public Object read(T attributes) {
            return this.getter.read(attributes);
        }
    }

    @FunctionalInterface
    private static interface AttributeGetter<T extends BasicFileAttributes> {
        public Object read(T var1);

        public static <T extends BasicFileAttributes> AttributeGetterImpl<T> getter(String name, Class<T> type, AttributeGetter<T> getter) {
            return new AttributeGetterImpl(name, type, getter);
        }
    }

    private static class AttributeSetterImpl<T extends FileAttributeView, V>
    implements AttributeSetter<T, V> {
        private final Class<T> type;
        private final Class<V> valueType;
        private final AttributeSetter<T, V> setter;

        private AttributeSetterImpl(Class<T> type, Class<V> valueType, AttributeSetter<T, V> setter) {
            this.type = type;
            this.valueType = valueType;
            this.setter = setter;
        }

        public Class<T> type() {
            return this.type;
        }

        @Override
        public void set(T attributes, V value) throws IOException {
            this.setter.set(attributes, this.valueType.cast(value));
        }
    }

    @FunctionalInterface
    private static interface AttributeSetter<T extends FileAttributeView, V> {
        public void set(T var1, V var2) throws IOException;

        public static <T extends FileAttributeView, V> AttributeSetterImpl<T, V> setter(Class<T> type, Class<V> valueType, AttributeSetter setter) {
            return new AttributeSetterImpl(type, valueType, setter);
        }
    }
}

