/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributes;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributes;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributes;
import org.cryptomator.cryptofs.common.ArrayUtils;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptolib.api.Cryptor;

@CryptoFileSystemScoped
public class AttributeProvider {
    private static final Map<Class<? extends BasicFileAttributes>, AttributesConstructor<? extends BasicFileAttributes>> ATTR_CONSTRUCTORS = new HashMap<Class<? extends BasicFileAttributes>, AttributesConstructor<? extends BasicFileAttributes>>();
    private final Cryptor cryptor;
    private final CryptoPathMapper pathMapper;
    private final OpenCryptoFiles openCryptoFiles;
    private final CryptoFileSystemProperties fileSystemProperties;
    private final Symlinks symlinks;

    @Inject
    AttributeProvider(Cryptor cryptor, CryptoPathMapper pathMapper, OpenCryptoFiles openCryptoFiles, CryptoFileSystemProperties fileSystemProperties, Symlinks symlinks) {
        this.cryptor = cryptor;
        this.pathMapper = pathMapper;
        this.openCryptoFiles = openCryptoFiles;
        this.fileSystemProperties = fileSystemProperties;
        this.symlinks = symlinks;
    }

    public <A extends BasicFileAttributes> A readAttributes(CryptoPath cleartextPath, Class<A> type, LinkOption ... options) throws IOException {
        if (!ATTR_CONSTRUCTORS.containsKey(type)) {
            throw new UnsupportedOperationException("Unsupported file attribute type: " + type);
        }
        CiphertextFileType ciphertextFileType = this.pathMapper.getCiphertextFileType(cleartextPath);
        switch (ciphertextFileType) {
            case SYMLINK: {
                if (ArrayUtils.contains(options, LinkOption.NOFOLLOW_LINKS)) {
                    Path ciphertextPath = this.pathMapper.getCiphertextFilePath(cleartextPath).getSymlinkFilePath();
                    return this.readAttributes(ciphertextFileType, ciphertextPath, type);
                }
                CryptoPath resolved = this.symlinks.resolveRecursively(cleartextPath);
                return this.readAttributes(resolved, type, options);
            }
            case DIRECTORY: {
                Path ciphertextPath = this.pathMapper.getCiphertextDir((CryptoPath)cleartextPath).path;
                return this.readAttributes(ciphertextFileType, ciphertextPath, type);
            }
            case FILE: {
                Path ciphertextPath = this.pathMapper.getCiphertextFilePath(cleartextPath).getFilePath();
                return this.readAttributes(ciphertextFileType, ciphertextPath, type);
            }
        }
        throw new UnsupportedOperationException("Unhandled node type " + (Object)((Object)ciphertextFileType));
    }

    private <A extends BasicFileAttributes> A readAttributes(CiphertextFileType ciphertextFileType, Path ciphertextPath, Class<A> type) throws IOException {
        assert (ATTR_CONSTRUCTORS.containsKey(type));
        A ciphertextAttrs = Files.readAttributes(ciphertextPath, type, new LinkOption[0]);
        AttributesConstructor<? extends BasicFileAttributes> constructor = ATTR_CONSTRUCTORS.get(type);
        return (A)constructor.construct((BasicFileAttributes)ciphertextAttrs, ciphertextFileType, ciphertextPath, this.cryptor, this.openCryptoFiles.get(ciphertextPath), this.fileSystemProperties.readonly());
    }

    static {
        ATTR_CONSTRUCTORS.put(BasicFileAttributes.class, CryptoBasicFileAttributes::new);
        ATTR_CONSTRUCTORS.put(PosixFileAttributes.class, CryptoPosixFileAttributes::new);
        ATTR_CONSTRUCTORS.put(DosFileAttributes.class, CryptoDosFileAttributes::new);
    }

    @FunctionalInterface
    private static interface AttributesConstructor<A extends BasicFileAttributes> {
        public A construct(A var1, CiphertextFileType var2, Path var3, Cryptor var4, Optional<OpenCryptoFile> var5, boolean var6);
    }
}

