/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttributeView;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CryptoFileSystemScoped
public class AttributeViewProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeViewProvider.class);
    private final AttributeViewComponent.Builder attrViewComponentBuilder;

    @Inject
    AttributeViewProvider(AttributeViewComponent.Builder attrViewComponentBuilder) {
        this.attrViewComponentBuilder = attrViewComponentBuilder;
    }

    public <A extends FileAttributeView> A getAttributeView(CryptoPath cleartextPath, Class<A> type, LinkOption ... options) {
        Optional<FileAttributeView> view = this.attrViewComponentBuilder.cleartextPath(cleartextPath).viewType(type).linkOptions(options).build().attributeView();
        if (view.isPresent() && type.isInstance(view.get())) {
            return (A)((FileAttributeView)type.cast(view.get()));
        }
        LOG.warn("Requested unsupported file attribute view: {}", (Object)type.getName());
        return null;
    }
}

