/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AbstractCryptoFileAttributeView;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewScoped;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

@AttributeViewScoped
class CryptoBasicFileAttributeView
extends AbstractCryptoFileAttributeView
implements BasicFileAttributeView {
    protected final AttributeProvider fileAttributeProvider;
    protected final ReadonlyFlag readonlyFlag;

    @Inject
    public CryptoBasicFileAttributeView(CryptoPath cleartextPath, CryptoPathMapper pathMapper, LinkOption[] linkOptions, Symlinks symlinks, OpenCryptoFiles openCryptoFiles, AttributeProvider fileAttributeProvider, ReadonlyFlag readonlyFlag) {
        super(cleartextPath, pathMapper, linkOptions, symlinks, openCryptoFiles);
        this.fileAttributeProvider = fileAttributeProvider;
        this.readonlyFlag = readonlyFlag;
    }

    @Override
    public String name() {
        return "basic";
    }

    @Override
    public BasicFileAttributes readAttributes() throws IOException {
        return this.fileAttributeProvider.readAttributes(this.cleartextPath, BasicFileAttributes.class, this.linkOptions);
    }

    @Override
    public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(BasicFileAttributeView.class).setTimes(lastModifiedTime, lastAccessTime, createTime);
        if (lastModifiedTime != null) {
            this.getOpenCryptoFile().ifPresent(file -> file.setLastModifiedTime(lastModifiedTime));
        }
    }
}

