/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewScoped;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

@AttributeViewScoped
class CryptoDosFileAttributeView
extends CryptoBasicFileAttributeView
implements DosFileAttributeView {
    @Inject
    public CryptoDosFileAttributeView(CryptoPath cleartextPath, CryptoPathMapper pathMapper, LinkOption[] linkOptions, Symlinks symlinks, OpenCryptoFiles openCryptoFiles, AttributeProvider fileAttributeProvider, ReadonlyFlag readonlyFlag) {
        super(cleartextPath, pathMapper, linkOptions, symlinks, openCryptoFiles, fileAttributeProvider, readonlyFlag);
    }

    @Override
    public String name() {
        return "dos";
    }

    @Override
    public DosFileAttributes readAttributes() throws IOException {
        return this.fileAttributeProvider.readAttributes(this.cleartextPath, DosFileAttributes.class, this.linkOptions);
    }

    @Override
    public void setReadOnly(boolean value) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(DosFileAttributeView.class).setReadOnly(value);
    }

    @Override
    public void setHidden(boolean value) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(DosFileAttributeView.class).setHidden(value);
    }

    @Override
    public void setSystem(boolean value) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(DosFileAttributeView.class).setSystem(value);
    }

    @Override
    public void setArchive(boolean value) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(DosFileAttributeView.class).setArchive(value);
    }
}

