/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributes;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptolib.api.Cryptor;

class CryptoPosixFileAttributes
extends CryptoBasicFileAttributes
implements PosixFileAttributes {
    private static final Set<PosixFilePermission> ALL_WRITE = EnumSet.of(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE);
    private final UserPrincipal owner;
    private final GroupPrincipal group;
    private final Set<PosixFilePermission> permissions;

    public CryptoPosixFileAttributes(PosixFileAttributes delegate, CiphertextFileType ciphertextFileType, Path ciphertextPath, Cryptor cryptor, Optional<OpenCryptoFile> openCryptoFile, boolean readonlyFileSystem) {
        super(delegate, ciphertextFileType, ciphertextPath, cryptor, openCryptoFile, readonlyFileSystem);
        this.owner = delegate.owner();
        this.group = delegate.group();
        this.permissions = readonlyFileSystem ? Sets.difference(delegate.permissions(), ALL_WRITE) : delegate.permissions();
    }

    @Override
    public UserPrincipal owner() {
        return this.owner;
    }

    @Override
    public GroupPrincipal group() {
        return this.group;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        return this.permissions;
    }
}

