/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.common;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCapabilityChecker {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemCapabilityChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCapabilities(Path pathToVault) throws MissingCapabilityException {
        Path checkDir = pathToVault.resolve("c");
        try {
            this.checkLongFilenames(checkDir);
            this.checkLongFilePaths(checkDir);
        }
        catch (Throwable throwable) {
            try {
                MoreFiles.deleteRecursively((Path)checkDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException e) {
                LOG.warn("Failed to clean up " + checkDir, (Throwable)e);
            }
            throw throwable;
        }
        try {
            MoreFiles.deleteRecursively((Path)checkDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            LOG.warn("Failed to clean up " + checkDir, (Throwable)e);
        }
    }

    private void checkLongFilenames(Path checkDir) throws MissingCapabilityException {
        String longFileName = Strings.repeat((String)"a", (int)226) + ".c9r";
        Path p = checkDir.resolve(longFileName);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MissingCapabilityException(p, Capability.LONG_FILENAMES);
        }
    }

    private void checkLongFilePaths(Path checkDir) throws MissingCapabilityException {
        String longFileName = Strings.repeat((String)"a", (int)96) + ".c9r";
        String longPath = Joiner.on((char)'/').join((Object)longFileName, (Object)longFileName, new Object[]{longFileName, longFileName});
        Path p = checkDir.resolve(longPath);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MissingCapabilityException(p, Capability.LONG_PATHS);
        }
    }

    public static class MissingCapabilityException
    extends FileSystemException {
        private final Capability missingCapability;

        public MissingCapabilityException(Path path, Capability missingCapability) {
            super(path.toString(), null, "Filesystem doesn't support " + (Object)((Object)missingCapability));
            this.missingCapability = missingCapability;
        }

        public Capability getMissingCapability() {
            return this.missingCapability;
        }
    }

    public static enum Capability {
        LONG_FILENAMES,
        LONG_PATHS;

    }
}

