/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.fh.ChunkData;
import org.cryptomator.cryptofs.fh.ChunkLoader;
import org.cryptomator.cryptofs.fh.ChunkSaver;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;

@OpenFileScoped
public class ChunkCache {
    public static final int MAX_CACHED_CLEARTEXT_CHUNKS = 5;
    private final ChunkLoader chunkLoader;
    private final ChunkSaver chunkSaver;
    private final CryptoFileSystemStats stats;
    private final LoadingCache<Long, ChunkData> chunks;

    @Inject
    public ChunkCache(ChunkLoader chunkLoader, ChunkSaver chunkSaver, CryptoFileSystemStats stats) {
        this.chunkLoader = chunkLoader;
        this.chunkSaver = chunkSaver;
        this.stats = stats;
        this.chunks = CacheBuilder.newBuilder().maximumSize(5L).removalListener(this::removeChunk).build(CacheLoader.from(this::loadChunk));
    }

    private ChunkData loadChunk(Long chunkIndex) {
        try {
            this.stats.addChunkCacheMiss();
            return this.chunkLoader.load(chunkIndex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void removeChunk(RemovalNotification<Long, ChunkData> removal) {
        try {
            this.chunkSaver.save((Long)removal.getKey(), (ChunkData)removal.getValue());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ChunkData get(long chunkIndex) throws IOException {
        try {
            this.stats.addChunkCacheAccess();
            return (ChunkData)this.chunks.get((Object)chunkIndex);
        }
        catch (ExecutionException e) {
            assert (e.getCause() != null);
            throw (IOException)e.getCause();
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof UncheckedIOException) {
                UncheckedIOException uioe = (UncheckedIOException)e.getCause();
                throw uioe.getCause();
            }
            if (e.getCause() instanceof AuthenticationFailedException) {
                throw new IOException(e.getCause());
            }
            throw e;
        }
    }

    public void set(long chunkIndex, ChunkData data) {
        this.chunks.put((Object)chunkIndex, (Object)data);
    }

    public void invalidateAll() {
        this.chunks.invalidateAll();
    }
}

