/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.nio.ByteBuffer;
import org.cryptomator.cryptofs.fh.ByteSource;

public class ChunkData {
    private final ByteBuffer bytes;
    private boolean dirty;
    private int length;

    public static ChunkData wrap(ByteBuffer bytes) {
        return new ChunkData(bytes, bytes.limit());
    }

    public static ChunkData emptyWithSize(int size) {
        return new ChunkData(ByteBuffer.allocate(size), 0);
    }

    private ChunkData(ByteBuffer bytes, int length) {
        this.bytes = bytes;
        this.dirty = false;
        this.length = length;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void truncate(int length) {
        if (this.length > length) {
            this.length = length;
            this.dirty = true;
        }
    }

    public CopyWithoutDirection copyData() {
        return this.copyDataStartingAt(0);
    }

    public CopyWithoutDirection copyDataStartingAt(final int offset) {
        return new CopyWithoutDirection(){

            @Override
            public void to(ByteBuffer target) {
                ChunkData.this.bytes.limit(Math.min(ChunkData.this.length, target.remaining() + offset));
                ChunkData.this.bytes.position(offset);
                target.put(ChunkData.this.bytes);
            }

            @Override
            public void from(ByteBuffer source) {
                this.from(ByteSource.from(source));
            }

            @Override
            public void from(ByteSource source) {
                ChunkData.this.dirty = true;
                ChunkData.this.bytes.limit(ChunkData.this.bytes.capacity());
                ChunkData.this.bytes.position(offset);
                source.copyTo(ChunkData.this.bytes);
                ChunkData.this.length = Math.max(ChunkData.this.length, ChunkData.this.bytes.position());
            }
        };
    }

    public ByteBuffer asReadOnlyBuffer() {
        ByteBuffer readOnlyBuffer = this.bytes.asReadOnlyBuffer();
        readOnlyBuffer.position(0);
        readOnlyBuffer.limit(this.length);
        return readOnlyBuffer;
    }

    public String toString() {
        return String.format("ChunkData(dirty: %s, length: %d, capacity: %d)", this.dirty, this.length, this.bytes.capacity());
    }

    public static interface CopyWithoutDirection {
        public void to(ByteBuffer var1);

        public void from(ByteBuffer var1);

        public void from(ByteSource var1);
    }
}

