/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import dagger.MapKey;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v6.Version6Migrator;
import org.cryptomator.cryptofs.migration.v7.Version7Migrator;
import org.cryptomator.cryptolib.api.CryptorProvider;

@Module
class MigrationModule {
    private final CryptorProvider version1Cryptor;

    MigrationModule(CryptorProvider version1Cryptor) {
        this.version1Cryptor = version1Cryptor;
    }

    @Provides
    CryptorProvider provideVersion1CryptorProvider() {
        return this.version1Cryptor;
    }

    @Provides
    FileSystemCapabilityChecker provideFileSystemCapabilityChecker() {
        return new FileSystemCapabilityChecker();
    }

    @Provides
    @IntoMap
    @MigratorKey(value=Migration.FIVE_TO_SIX)
    Migrator provideVersion6Migrator(Version6Migrator migrator) {
        return migrator;
    }

    @Provides
    @IntoMap
    @MigratorKey(value=Migration.SIX_TO_SEVEN)
    Migrator provideVersion7Migrator(Version7Migrator migrator) {
        return migrator;
    }

    @Documented
    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @MapKey
    public static @interface MigratorKey {
        public Migration value();
    }
}

