/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.migration.DaggerMigrationComponent;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.MigrationComponent;
import org.cryptomator.cryptofs.migration.MigrationModule;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.api.NoApplicableMigratorException;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;

public class Migrators {
    private static final MigrationComponent COMPONENT = DaggerMigrationComponent.builder().migrationModule(new MigrationModule(Cryptors.version1((SecureRandom)Migrators.strongSecureRandom()))).build();
    private final Map<Migration, Migrator> migrators;
    private final FileSystemCapabilityChecker fsCapabilityChecker;

    @Inject
    Migrators(Map<Migration, Migrator> migrators, FileSystemCapabilityChecker fsCapabilityChecker) {
        this.migrators = migrators;
        this.fsCapabilityChecker = fsCapabilityChecker;
    }

    private static SecureRandom strongSecureRandom() {
        try {
            return SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("A strong algorithm must exist in every Java platform.", e);
        }
    }

    public static Migrators get() {
        return COMPONENT.migrators();
    }

    public boolean needsMigration(Path pathToVault, String masterkeyFilename) throws IOException {
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        byte[] keyFileContents = Files.readAllBytes(masterKeyPath);
        KeyFile keyFile = KeyFile.parse((byte[])keyFileContents);
        return keyFile.getVersion() < 7;
    }

    public void migrate(Path pathToVault, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener) throws NoApplicableMigratorException, InvalidPassphraseException, IOException {
        this.fsCapabilityChecker.checkCapabilities(pathToVault);
        Path masterKeyPath = pathToVault.resolve(masterkeyFilename);
        byte[] keyFileContents = Files.readAllBytes(masterKeyPath);
        KeyFile keyFile = KeyFile.parse((byte[])keyFileContents);
        try {
            Migrator migrator = this.findApplicableMigrator(keyFile.getVersion()).orElseThrow(NoApplicableMigratorException::new);
            migrator.migrate(pathToVault, masterkeyFilename, passphrase, progressListener);
        }
        catch (UnsupportedVaultFormatException e) {
            throw new IllegalStateException("Vault version checked beforehand but not supported by migrator.");
        }
    }

    private Optional<Migrator> findApplicableMigrator(int version) {
        return this.migrators.entrySet().stream().filter(entry -> ((Migration)((Object)((Object)entry.getKey()))).isApplicable(version)).map(Map.Entry::getValue).findAny();
    }
}

