/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v6;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.text.Normalizer;
import javax.inject.Inject;
import org.cryptomator.cryptofs.common.MasterkeyBackupFileHasher;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version6Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version6Migrator.class);
    private final CryptorProvider cryptorProvider;

    @Inject
    public Version6Migrator(CryptorProvider cryptorProvider) {
        this.cryptorProvider = cryptorProvider;
    }

    @Override
    public void migrate(Path vaultRoot, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener) throws InvalidPassphraseException, UnsupportedVaultFormatException, IOException {
        LOG.info("Upgrading {} from version 5 to version 6.", (Object)vaultRoot);
        progressListener.update(MigrationProgressListener.ProgressState.INITIALIZING, 0.0);
        Path masterkeyFile = vaultRoot.resolve(masterkeyFilename);
        byte[] fileContentsBeforeUpgrade = Files.readAllBytes(masterkeyFile);
        KeyFile keyFile = KeyFile.parse((byte[])fileContentsBeforeUpgrade);
        try (Cryptor cryptor = this.cryptorProvider.createFromKeyFile(keyFile, passphrase, 5);){
            Path masterkeyBackupFile = vaultRoot.resolve(masterkeyFilename + MasterkeyBackupFileHasher.generateFileIdSuffix(fileContentsBeforeUpgrade) + ".bkup");
            Files.copy(masterkeyFile, masterkeyBackupFile, StandardCopyOption.REPLACE_EXISTING);
            LOG.info("Backed up masterkey from {} to {}.", (Object)masterkeyFile.getFileName(), (Object)masterkeyBackupFile.getFileName());
            progressListener.update(MigrationProgressListener.ProgressState.FINALIZING, 0.0);
            byte[] fileContentsAfterUpgrade = cryptor.writeKeysToMasterkeyFile((CharSequence)Normalizer.normalize(passphrase, Normalizer.Form.NFC), 6).serialize();
            Files.write(masterkeyFile, fileContentsAfterUpgrade, StandardOpenOption.TRUNCATE_EXISTING);
            LOG.info("Updated masterkey.");
        }
        LOG.info("Upgraded {} from version 5 to version 6.", (Object)vaultRoot);
    }
}

