/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v7;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.v7.FilePathMigration;
import org.cryptomator.cryptofs.migration.v7.UninflatableFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigratingVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(MigratingVisitor.class);
    private final Path vaultRoot;
    private final MigrationProgressListener progressListener;
    private final long estimatedTotalFiles;
    private Collection<FilePathMigration> migrationsInCurrentDir = new ArrayList<FilePathMigration>();
    private long migratedFiles = 0L;

    public MigratingVisitor(Path vaultRoot, MigrationProgressListener progressListener, long estimatedTotalFiles) {
        this.vaultRoot = vaultRoot;
        this.progressListener = progressListener;
        this.estimatedTotalFiles = estimatedTotalFiles;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Optional<FilePathMigration> migration;
        try {
            migration = FilePathMigration.parse(this.vaultRoot, file);
        }
        catch (UninflatableFileException e) {
            LOG.warn("SKIP {} because inflation failed.", (Object)file);
            return FileVisitResult.CONTINUE;
        }
        migration.ifPresent(this.migrationsInCurrentDir::add);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        for (FilePathMigration migration : this.migrationsInCurrentDir) {
            ++this.migratedFiles;
            this.progressListener.update(MigrationProgressListener.ProgressState.MIGRATING, (double)this.migratedFiles / (double)this.estimatedTotalFiles);
            try {
                Path migratedFile = migration.migrate();
                LOG.info("MOVED {} to {}", (Object)migration.getOldPath(), (Object)migratedFile);
            }
            catch (FileAlreadyExistsException e) {
                LOG.error("Failed to migrate " + migration.getOldPath() + " due to FileAlreadyExistsException. Already migrated on a different machine?.", (Throwable)e);
                return FileVisitResult.TERMINATE;
            }
        }
        this.migrationsInCurrentDir.clear();
        return FileVisitResult.CONTINUE;
    }
}

