/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v7;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import org.cryptomator.cryptofs.common.DeletingFileVisitor;
import org.cryptomator.cryptofs.common.MasterkeyBackupFileHasher;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v7.MigratingVisitor;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;
import org.cryptomator.cryptolib.api.UnsupportedVaultFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version7Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version7Migrator.class);
    private final CryptorProvider cryptorProvider;

    @Inject
    public Version7Migrator(CryptorProvider cryptorProvider) {
        this.cryptorProvider = cryptorProvider;
    }

    @Override
    public void migrate(Path vaultRoot, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener) throws InvalidPassphraseException, UnsupportedVaultFormatException, IOException {
        LOG.info("Upgrading {} from version 6 to version 7.", (Object)vaultRoot);
        progressListener.update(MigrationProgressListener.ProgressState.INITIALIZING, 0.0);
        Path masterkeyFile = vaultRoot.resolve(masterkeyFilename);
        byte[] fileContentsBeforeUpgrade = Files.readAllBytes(masterkeyFile);
        KeyFile keyFile = KeyFile.parse((byte[])fileContentsBeforeUpgrade);
        try (Cryptor cryptor = this.cryptorProvider.createFromKeyFile(keyFile, passphrase, 6);){
            Path masterkeyBackupFile = vaultRoot.resolve(masterkeyFilename + MasterkeyBackupFileHasher.generateFileIdSuffix(fileContentsBeforeUpgrade) + ".bkup");
            Files.copy(masterkeyFile, masterkeyBackupFile, StandardCopyOption.REPLACE_EXISTING);
            LOG.info("Backed up masterkey from {} to {}.", (Object)masterkeyFile.getFileName(), (Object)masterkeyBackupFile.getFileName());
            long toBeMigrated = this.countFileNames(vaultRoot);
            if (toBeMigrated > 0L) {
                this.migrateFileNames(vaultRoot, progressListener, toBeMigrated);
            }
            progressListener.update(MigrationProgressListener.ProgressState.FINALIZING, 0.0);
            Files.walkFileTree(vaultRoot.resolve("m"), DeletingFileVisitor.INSTANCE);
            byte[] fileContentsAfterUpgrade = cryptor.writeKeysToMasterkeyFile(passphrase, 7).serialize();
            Files.write(masterkeyFile, fileContentsAfterUpgrade, StandardOpenOption.TRUNCATE_EXISTING);
            LOG.info("Updated masterkey.");
        }
        LOG.info("Upgraded {} from version 6 to version 7.", (Object)vaultRoot);
    }

    private long countFileNames(Path vaultRoot) throws IOException {
        final LongAdder counter = new LongAdder();
        Path dataDir = vaultRoot.resolve("d");
        Files.walkFileTree(dataDir, EnumSet.noneOf(FileVisitOption.class), 3, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                counter.increment();
                return FileVisitResult.CONTINUE;
            }
        });
        return counter.sum();
    }

    private void migrateFileNames(Path vaultRoot, MigrationProgressListener progressListener, long totalFiles) throws IOException {
        assert (totalFiles > 0L);
        Path dataDir = vaultRoot.resolve("d");
        Files.walkFileTree(dataDir, EnumSet.noneOf(FileVisitOption.class), 3, new MigratingVisitor(vaultRoot, progressListener, totalFiles));
    }
}

