/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.shortened;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public class TrailingBytesInNameFile
implements DiagnosticResult {
    private final Path nameFile;
    private final String longName;

    public TrailingBytesInNameFile(Path nameFile, String longName) {
        this.nameFile = nameFile;
        this.longName = longName;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.WARN;
    }

    @Override
    public void fix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) throws IOException {
        int startIndexTrailingBytes = this.longName.indexOf(".c9r") + ".c9r".length();
        Files.writeString(pathToVault.resolve(this.nameFile), (CharSequence)this.longName.substring(0, startIndexTrailingBytes), StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.nameFile.toString(), "Encrypted Long Name", this.longName);
    }
}

