/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.cryptofs.common.RunnableThrowingException;

@Singleton
public class FinallyUtil {
    @Inject
    public FinallyUtil() {
    }

    public <E extends Exception> void guaranteeInvocationOf(RunnableThrowingException<? extends E> ... tasks) throws E {
        this.guaranteeInvocationOf(Arrays.stream(tasks));
    }

    public <E extends Exception> void guaranteeInvocationOf(Iterable<RunnableThrowingException<? extends E>> tasks) throws E {
        this.guaranteeInvocationOf(StreamSupport.stream(tasks.spliterator(), false));
    }

    public <E extends Exception> void guaranteeInvocationOf(Stream<RunnableThrowingException<? extends E>> tasks) throws E {
        this.guaranteeInvocationOf(tasks.map(t -> t).iterator());
    }

    public <E extends Exception> void guaranteeInvocationOf(Iterator<RunnableThrowingException<E>> tasks) throws E {
        if (tasks.hasNext()) {
            RunnableThrowingException<E> next = tasks.next();
            try {
                next.run();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.guaranteeInvocationOf(tasks);
            }
        }
    }
}

