/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.shortened;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.CheckFailed;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.cryptofs.health.shortened.LongShortNamesMismatch;
import org.cryptomator.cryptofs.health.shortened.MissingLongName;
import org.cryptomator.cryptofs.health.shortened.NotDecodableLongName;
import org.cryptomator.cryptofs.health.shortened.ObeseNameFile;
import org.cryptomator.cryptofs.health.shortened.TrailingBytesInNameFile;
import org.cryptomator.cryptofs.health.shortened.ValidShortenedFile;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MessageDigestSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortenedNamesCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ShortenedNamesCheck.class);
    private static final int MAX_TRAVERSAL_DEPTH = 3;
    private static final BaseEncoding BASE64URL = BaseEncoding.base64Url();

    @Override
    public String name() {
        return "Shortened Names Check";
    }

    @Override
    public void check(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor, Consumer<DiagnosticResult> resultCollector) {
        Path dataDirPath = pathToVault.resolve("d");
        DirVisitor dirVisitor = new DirVisitor(resultCollector);
        try {
            Files.walkFileTree(dataDirPath, Set.of(), 3, dirVisitor);
        }
        catch (IOException e) {
            LOG.error("Traversal of data dir failed.", (Throwable)e);
            resultCollector.accept(new CheckFailed("Traversal of data dir failed. See log for details."));
        }
    }

    static class DirVisitor
    extends SimpleFileVisitor<Path> {
        private final Consumer<DiagnosticResult> resultCollector;

        public DirVisitor(Consumer<DiagnosticResult> resultCollector) {
            this.resultCollector = resultCollector;
        }

        @Override
        public FileVisitResult visitFile(Path dir, BasicFileAttributes attrs) throws IOException {
            String name = dir.getFileName().toString();
            if (attrs.isDirectory() && name.endsWith(".c9s")) {
                this.checkShortenedName(dir);
            }
            return FileVisitResult.CONTINUE;
        }

        void checkShortenedName(Path dir) throws IOException {
            BasicFileAttributes attrs;
            Path nameFile = dir.resolve("name.c9s");
            try {
                attrs = Files.getFileAttributeView(nameFile, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
            }
            catch (NoSuchFileException e) {
                this.resultCollector.accept(new MissingLongName(dir));
                return;
            }
            if (!attrs.isRegularFile()) {
                this.resultCollector.accept(new MissingLongName(dir));
                return;
            }
            if (attrs.size() > 10240L) {
                this.resultCollector.accept(new ObeseNameFile(nameFile, attrs.size()));
                return;
            }
            String longName = Files.readString(nameFile, StandardCharsets.UTF_8);
            SyntaxResult syntaxResult = this.checkSyntax(longName);
            if (syntaxResult == SyntaxResult.INVALID) {
                this.resultCollector.accept(new NotDecodableLongName(nameFile, longName));
                return;
            }
            if (syntaxResult == SyntaxResult.TRAILING_BYTES) {
                this.resultCollector.accept(new TrailingBytesInNameFile(nameFile, longName));
                return;
            }
            String expectedShortName = this.deflate(longName);
            if (!dir.getFileName().toString().equals(expectedShortName)) {
                this.resultCollector.accept(new LongShortNamesMismatch(dir, expectedShortName));
            } else {
                this.resultCollector.accept(new ValidShortenedFile(dir));
            }
        }

        SyntaxResult checkSyntax(String toAnalyse) {
            int posObligatoryC9rString = toAnalyse.indexOf(".c9r");
            if (posObligatoryC9rString == -1) {
                return SyntaxResult.INVALID;
            }
            String encryptedFileName = toAnalyse.substring(0, posObligatoryC9rString);
            if (!BASE64URL.canDecode((CharSequence)encryptedFileName)) {
                return SyntaxResult.INVALID;
            }
            if (toAnalyse.length() > posObligatoryC9rString + ".c9r".length()) {
                return SyntaxResult.TRAILING_BYTES;
            }
            return SyntaxResult.VALID;
        }

        String deflate(String longFileName) {
            byte[] longFileNameBytes = longFileName.getBytes(StandardCharsets.UTF_8);
            byte[] hash = MessageDigestSupplier.SHA1.get().digest(longFileNameBytes);
            return BASE64URL.encode(hash) + ".c9s";
        }

        static enum SyntaxResult {
            VALID,
            INVALID,
            TRAILING_BYTES;

        }
    }
}

