/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import org.cryptomator.cryptofs.ReadonlyFlag;

public class EffectiveOpenOptions {
    private final ReadonlyFlag readonlyFlag;
    private final Set<OpenOption> options;

    private EffectiveOpenOptions(Set<? extends OpenOption> options, ReadonlyFlag readonlyFlag) throws IOException {
        this.readonlyFlag = readonlyFlag;
        this.options = this.cleanAndValidate(options);
    }

    public static EffectiveOpenOptions from(Set<? extends OpenOption> options, ReadonlyFlag readonlyFlag) throws IOException {
        return new EffectiveOpenOptions(options, readonlyFlag);
    }

    public boolean noFollowLinks() {
        return this.options.contains(LinkOption.NOFOLLOW_LINKS);
    }

    public boolean writable() {
        return this.options.contains(StandardOpenOption.WRITE);
    }

    public boolean readable() {
        return this.options.contains(StandardOpenOption.READ);
    }

    public boolean syncDataAndMetadata() {
        return this.options.contains(StandardOpenOption.SYNC);
    }

    public boolean syncData() {
        return this.syncDataAndMetadata() || this.options.contains(StandardOpenOption.DSYNC);
    }

    public boolean append() {
        return this.options.contains(StandardOpenOption.APPEND);
    }

    public boolean createNew() {
        return this.options.contains(StandardOpenOption.CREATE_NEW);
    }

    public boolean create() {
        return this.options.contains(StandardOpenOption.CREATE);
    }

    public boolean truncateExisting() {
        return this.options.contains(StandardOpenOption.TRUNCATE_EXISTING);
    }

    public boolean deleteOnClose() {
        return this.options.contains(StandardOpenOption.DELETE_ON_CLOSE);
    }

    private Set<OpenOption> cleanAndValidate(Set<? extends OpenOption> originalOptions) throws IOException {
        HashSet<OpenOption> cleanedOptions = new HashSet<OpenOption>(originalOptions);
        this.addWriteIfAppendIsPresent(cleanedOptions);
        this.addReadIfWriteIsAbsent(cleanedOptions);
        this.validateAppendIsNotPresentInConjuntionWithTruncateExistingOrRead(originalOptions);
        this.removeSparse(cleanedOptions);
        this.removeCreateIfCreateNewIsPresent(cleanedOptions);
        this.removeCreateAndTruncateOptionsIfWriteIsAbsent(cleanedOptions);
        this.validateNoUnsupportedOptionsArePresent(cleanedOptions);
        this.assertWritableIfWriteOrDeleteOnCloseIsPresent(cleanedOptions);
        return cleanedOptions;
    }

    private void addWriteIfAppendIsPresent(Set<OpenOption> options) {
        if (options.contains(StandardOpenOption.APPEND)) {
            options.add(StandardOpenOption.WRITE);
        }
    }

    private void addReadIfWriteIsAbsent(Set<OpenOption> options) {
        if (!options.contains(StandardOpenOption.WRITE)) {
            options.add(StandardOpenOption.READ);
        }
    }

    private void validateAppendIsNotPresentInConjuntionWithTruncateExistingOrRead(Set<? extends OpenOption> options) {
        if (options.contains(StandardOpenOption.APPEND) && (options.contains(StandardOpenOption.READ) || options.contains(StandardOpenOption.TRUNCATE_EXISTING))) {
            throw new IllegalArgumentException("StandardOpenOption APPEND may not be used in conjuction with READ or TRUNCATE_EXISTING");
        }
    }

    private void removeSparse(Set<OpenOption> options) {
        options.remove(StandardOpenOption.SPARSE);
    }

    private void removeCreateAndTruncateOptionsIfWriteIsAbsent(Set<OpenOption> options) {
        if (!options.contains(StandardOpenOption.WRITE)) {
            options.remove(StandardOpenOption.TRUNCATE_EXISTING);
            options.remove(StandardOpenOption.CREATE_NEW);
            options.remove(StandardOpenOption.CREATE);
        }
    }

    private void removeCreateIfCreateNewIsPresent(Set<OpenOption> options) {
        if (options.contains(StandardOpenOption.CREATE_NEW)) {
            options.remove(StandardOpenOption.CREATE);
        }
    }

    private void validateNoUnsupportedOptionsArePresent(Set<OpenOption> options) {
        for (OpenOption option : options) {
            if (this.isSupported(option)) continue;
            throw new IllegalArgumentException("Unsupported option option " + option);
        }
    }

    private void assertWritableIfWriteOrDeleteOnCloseIsPresent(Set<OpenOption> cleanedOptions) throws IOException {
        if (cleanedOptions.contains(StandardOpenOption.WRITE) || cleanedOptions.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
            this.readonlyFlag.assertWritable();
        }
    }

    private boolean isSupported(OpenOption option) {
        return option instanceof StandardOpenOption || option instanceof LinkOption;
    }

    public Set<OpenOption> createOpenOptionsForEncryptedFile() {
        HashSet<OpenOption> result = new HashSet<OpenOption>(this.options);
        result.add(StandardOpenOption.READ);
        result.remove(LinkOption.NOFOLLOW_LINKS);
        result.remove(StandardOpenOption.APPEND);
        return result;
    }
}

