/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.ch;

import java.nio.ByteBuffer;
import org.cryptomator.cryptolib.common.ByteBuffers;

interface ByteSource {
    public static ByteSource from(ByteBuffer buffer) {
        return new ByteBufferByteSource(buffer);
    }

    public static ZeroPrefixedByteSourceWithoutBuffer repeatingZeroes(long amountOfZeroes) {
        return buffer -> new ZeroPrefixedByteSource(amountOfZeroes, buffer);
    }

    public boolean hasRemaining();

    public long remaining();

    public void copyTo(ByteBuffer var1);

    public static class ByteBufferByteSource
    implements ByteSource {
        private final ByteBuffer source;

        private ByteBufferByteSource(ByteBuffer source) {
            this.source = source;
        }

        @Override
        public boolean hasRemaining() {
            return this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer target) {
            if (this.source.remaining() > target.remaining()) {
                ByteBuffers.copy((ByteBuffer)this.source, (ByteBuffer)target);
            } else {
                target.put(this.source);
            }
        }
    }

    public static interface ZeroPrefixedByteSourceWithoutBuffer {
        public ByteSource followedBy(ByteBuffer var1);
    }

    public static class ZeroPrefixedByteSource
    implements ByteSource {
        private static final ByteBuffer ZEROES = ByteBuffer.allocate(4069);
        private long amountOfZeroes;
        private final ByteBuffer source;

        private ZeroPrefixedByteSource(long amountOfZeroes, ByteBuffer source) {
            this.amountOfZeroes = amountOfZeroes;
            this.source = source;
        }

        @Override
        public boolean hasRemaining() {
            return this.amountOfZeroes > 0L || this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.amountOfZeroes + (long)this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer target) {
            while (this.amountOfZeroes > 0L && target.hasRemaining()) {
                this.copyZeroesTo(target);
            }
            if (target.hasRemaining()) {
                this.copySourceTo(target);
            }
        }

        private void copyZeroesTo(ByteBuffer target) {
            ByteBuffer zeroes = ZEROES.asReadOnlyBuffer();
            int amountOfZeroesToCopy = (int)Math.min(this.amountOfZeroes, (long)zeroes.remaining());
            zeroes.limit(amountOfZeroesToCopy);
            this.amountOfZeroes -= (long)ByteBuffers.copy((ByteBuffer)zeroes, (ByteBuffer)target);
        }

        private void copySourceTo(ByteBuffer target) {
            if (this.source.remaining() > target.remaining()) {
                ByteBuffers.copy((ByteBuffer)this.source, (ByteBuffer)target);
            } else {
                target.put(this.source);
            }
        }
    }
}

