/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.CheckFailed;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.cryptofs.health.dirid.DirIdCollision;
import org.cryptomator.cryptofs.health.dirid.EmptyDirFile;
import org.cryptomator.cryptofs.health.dirid.HealthyDir;
import org.cryptomator.cryptofs.health.dirid.LooseDirFile;
import org.cryptomator.cryptofs.health.dirid.MissingContentDir;
import org.cryptomator.cryptofs.health.dirid.MissingDirIdBackup;
import org.cryptomator.cryptofs.health.dirid.ObeseDirFile;
import org.cryptomator.cryptofs.health.dirid.OrphanContentDir;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirIdCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DirIdCheck.class);
    private static final int MAX_TRAVERSAL_DEPTH = 4;
    private static final String CHECK_NAME = "Directory Check";

    @Override
    public String name() {
        return CHECK_NAME;
    }

    @Override
    public void check(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor, Consumer<DiagnosticResult> resultCollector) {
        Path dataDirPath = pathToVault.resolve("d");
        DirVisitor dirVisitor = new DirVisitor(dataDirPath, resultCollector);
        try {
            Files.walkFileTree(dataDirPath, Set.of(), 4, dirVisitor);
        }
        catch (IOException e) {
            LOG.error("Traversal of data dir failed.", (Throwable)e);
            resultCollector.accept(new CheckFailed("Traversal of data dir failed. See log for details."));
            return;
        }
        Iterator<Map.Entry<String, Path>> iter = dirVisitor.dirIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Path> entry = iter.next();
            String dirId2 = entry.getKey();
            Path dirFile2 = entry.getValue();
            String hashedDirId = cryptor.fileNameCryptor().hashDirectoryId(dirId2);
            Path expectedDir = Path.of(hashedDirId.substring(0, 2), hashedDirId.substring(2));
            boolean foundDir = dirVisitor.secondLevelDirs.remove(expectedDir);
            if (!foundDir) continue;
            iter.remove();
            Path expectedDirVaultRel = Path.of("d", new String[0]).resolve(expectedDir);
            if (Files.exists(pathToVault.resolve(expectedDirVaultRel).resolve("dirid.c9r"), new LinkOption[0])) {
                resultCollector.accept(new HealthyDir(dirId2, dirFile2, expectedDirVaultRel));
                continue;
            }
            resultCollector.accept(new MissingDirIdBackup(dirId2, expectedDirVaultRel));
        }
        dirVisitor.dirIds.forEach((dirId, dirFile) -> resultCollector.accept(new MissingContentDir((String)dirId, (Path)dirFile)));
        dirVisitor.secondLevelDirs.forEach(dir -> resultCollector.accept(new OrphanContentDir((Path)dir)));
    }

    static class DirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dataDirPath;
        private final Consumer<DiagnosticResult> resultCollector;
        public final Map<String, Path> dirIds = new HashMap<String, Path>();
        public final Set<Path> secondLevelDirs = new HashSet<Path>();
        public final Set<Path> c9rDirsWithDirId = new HashSet<Path>();

        public DirVisitor(Path dataDirPath, Consumer<DiagnosticResult> resultCollector) {
            this.dataDirPath = dataDirPath;
            this.resultCollector = resultCollector;
            this.dirIds.put("", null);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if ("dir.c9r".equals(file.getFileName().toString())) {
                this.c9rDirsWithDirId.add(file.getParent());
                return this.visitDirFile(file, attrs);
            }
            return FileVisitResult.CONTINUE;
        }

        private FileVisitResult visitDirFile(Path dirFile, BasicFileAttributes attrs) throws IOException {
            assert ("dir.c9r".equals(dirFile.getFileName().toString()));
            String parentDirName = dirFile.getParent().getFileName().toString();
            if (!parentDirName.endsWith(".c9r") && !parentDirName.endsWith(".c9s")) {
                LOG.warn("Encountered loose dir.c9r file.");
                this.resultCollector.accept(new LooseDirFile(dirFile));
                return FileVisitResult.CONTINUE;
            }
            if (attrs.size() > 36L) {
                LOG.warn("Encountered dir.c9r file of size {}", (Object)attrs.size());
                this.resultCollector.accept(new ObeseDirFile(dirFile, attrs.size()));
            } else if (attrs.size() == 0L) {
                LOG.warn("Empty dir.c9r file at {}.", (Object)dirFile);
                this.resultCollector.accept(new EmptyDirFile(dirFile));
            } else {
                byte[] bytes = Files.readAllBytes(dirFile);
                String dirId = new String(bytes, StandardCharsets.UTF_8);
                if (this.dirIds.containsKey(dirId)) {
                    Path otherFile = this.dirIds.get(dirId);
                    LOG.warn("Same directory ID used by {} and {}", (Object)dirFile, (Object)otherFile);
                    this.resultCollector.accept(new DirIdCollision(dirId, dirFile, otherFile));
                } else {
                    this.dirIds.put(dirId, dirFile);
                    this.c9rDirsWithDirId.add(dirFile);
                }
            }
            return FileVisitResult.SKIP_SIBLINGS;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path relPath = this.dataDirPath.relativize(dir);
            if (relPath.getNameCount() == 2) {
                this.secondLevelDirs.add(relPath);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

