// Generated by Dagger (https://dagger.dev).
package org.cryptomator.cryptofs;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.Preconditions;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import javax.inject.Provider;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeComponent;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideAttributesFactory;
import org.cryptomator.cryptofs.attr.AttributeModule_ProvideOpenCryptoFileFactory;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeProvider_Factory;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.attr.AttributeViewModule_ProvideAttributeViewFactory;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider_Factory;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoFileOwnerAttributeView_Factory;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributeView_Factory;
import org.cryptomator.cryptofs.ch.ChannelCloseListener;
import org.cryptomator.cryptofs.ch.ChannelComponent;
import org.cryptomator.cryptofs.ch.CleartextFileChannel;
import org.cryptomator.cryptofs.ch.CleartextFileChannel_Factory;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker_Factory;
import org.cryptomator.cryptofs.common.FinallyUtil;
import org.cryptomator.cryptofs.common.FinallyUtil_Factory;
import org.cryptomator.cryptofs.dir.BrokenDirectoryFilter_Factory;
import org.cryptomator.cryptofs.dir.C9rConflictResolver_Factory;
import org.cryptomator.cryptofs.dir.C9rDecryptor_Factory;
import org.cryptomator.cryptofs.dir.C9rProcessor_Factory;
import org.cryptomator.cryptofs.dir.C9sInflator_Factory;
import org.cryptomator.cryptofs.dir.C9sProcessor_Factory;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter_Factory;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream_Factory;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory_Factory;
import org.cryptomator.cryptofs.dir.NodeProcessor_Factory;
import org.cryptomator.cryptofs.fh.BufferPool;
import org.cryptomator.cryptofs.fh.BufferPool_Factory;
import org.cryptomator.cryptofs.fh.ChunkCache;
import org.cryptomator.cryptofs.fh.ChunkCache_Factory;
import org.cryptomator.cryptofs.fh.ChunkIO_Factory;
import org.cryptomator.cryptofs.fh.ChunkLoader_Factory;
import org.cryptomator.cryptofs.fh.ChunkSaver_Factory;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite;
import org.cryptomator.cryptofs.fh.ExceptionsDuringWrite_Factory;
import org.cryptomator.cryptofs.fh.FileCloseListener;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.FileHeaderHolder_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideCurrentPathFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideFileSizeFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideLastModifiedDateFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFileModule_ProvideReadWriteLockFactory;
import org.cryptomator.cryptofs.fh.OpenCryptoFile_Factory;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles_Factory;
import org.cryptomator.cryptolib.api.Cryptor;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
final class DaggerCryptoFileSystemProviderComponent {
  private DaggerCryptoFileSystemProviderComponent() {
  }

  public static CryptoFileSystemProviderComponent.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements CryptoFileSystemProviderComponent.Builder {
    private SecureRandom csprng;

    @Override
    public Builder csprng(SecureRandom csprng) {
      this.csprng = Preconditions.checkNotNull(csprng);
      return this;
    }

    @Override
    public CryptoFileSystemProviderComponent build() {
      Preconditions.checkBuilderRequirement(csprng, SecureRandom.class);
      return new CryptoFileSystemProviderComponentImpl(csprng);
    }
  }

  private static final class CryptoFileSystemComponentFactory implements CryptoFileSystemComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private CryptoFileSystemComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
    }

    @Override
    public CryptoFileSystemComponent create(Cryptor cryptor, VaultConfig vaultConfig,
        CryptoFileSystemProvider provider, Path pathToVault,
        CryptoFileSystemProperties cryptoFileSystemProperties) {
      Preconditions.checkNotNull(cryptor);
      Preconditions.checkNotNull(vaultConfig);
      Preconditions.checkNotNull(provider);
      Preconditions.checkNotNull(pathToVault);
      Preconditions.checkNotNull(cryptoFileSystemProperties);
      return new CryptoFileSystemComponentImpl(cryptoFileSystemProviderComponentImpl, new CryptoFileSystemModule(), cryptor, vaultConfig, provider, pathToVault, cryptoFileSystemProperties);
    }
  }

  private static final class OpenCryptoFileComponentFactory implements OpenCryptoFileComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private OpenCryptoFileComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
    }

    @Override
    public OpenCryptoFileComponent create(Path path, FileCloseListener onCloseListener) {
      Preconditions.checkNotNull(path);
      Preconditions.checkNotNull(onCloseListener);
      return new OpenCryptoFileComponentImpl(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, new OpenCryptoFileModule(), path, onCloseListener);
    }
  }

  private static final class ChannelComponentFactory implements ChannelComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;

    private ChannelComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl,
        OpenCryptoFileComponentImpl openCryptoFileComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
      this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;
    }

    @Override
    public ChannelComponent create(FileChannel ciphertextChannel, EffectiveOpenOptions options,
        ChannelCloseListener listener) {
      Preconditions.checkNotNull(ciphertextChannel);
      Preconditions.checkNotNull(options);
      Preconditions.checkNotNull(listener);
      return new ChannelComponentImpl(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, openCryptoFileComponentImpl, ciphertextChannel, options, listener);
    }
  }

  private static final class DirectoryStreamComponentFactory implements DirectoryStreamComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private DirectoryStreamComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
    }

    @Override
    public DirectoryStreamComponent create(Path cleartextPath, String dirId,
        DirectoryStream<Path> ciphertextDirectoryStream,
        DirectoryStream.Filter<? super Path> filter, Consumer<CryptoDirectoryStream> onClose) {
      Preconditions.checkNotNull(cleartextPath);
      Preconditions.checkNotNull(dirId);
      Preconditions.checkNotNull(ciphertextDirectoryStream);
      Preconditions.checkNotNull(filter);
      Preconditions.checkNotNull(onClose);
      return new DirectoryStreamComponentImpl(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, cleartextPath, dirId, ciphertextDirectoryStream, filter, onClose);
    }
  }

  private static final class AttributeComponentFactory implements AttributeComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private AttributeComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
    }

    @Override
    public AttributeComponent create(Path ciphertextPath, CiphertextFileType ciphertextFileType,
        BasicFileAttributes ciphertextAttributes) {
      Preconditions.checkNotNull(ciphertextPath);
      Preconditions.checkNotNull(ciphertextFileType);
      Preconditions.checkNotNull(ciphertextAttributes);
      return new AttributeComponentImpl(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, ciphertextPath, ciphertextFileType, ciphertextAttributes);
    }
  }

  private static final class AttributeViewComponentFactory implements AttributeViewComponent.Factory {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private AttributeViewComponentFactory(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
    }

    @Override
    public AttributeViewComponent create(CryptoPath cleartextPath,
        Class<? extends FileAttributeView> type, LinkOption[] linkOptions) {
      Preconditions.checkNotNull(cleartextPath);
      Preconditions.checkNotNull(type);
      Preconditions.checkNotNull(linkOptions);
      return new AttributeViewComponentImpl(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, cleartextPath, type, linkOptions);
    }
  }

  private static final class ChannelComponentImpl implements ChannelComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl;

    private final ChannelComponentImpl channelComponentImpl = this;

    private Provider<FileChannel> ciphertextChannelProvider;

    private Provider<EffectiveOpenOptions> optionsProvider;

    private Provider<ChannelCloseListener> listenerProvider;

    private Provider<CleartextFileChannel> cleartextFileChannelProvider;

    private ChannelComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl,
        OpenCryptoFileComponentImpl openCryptoFileComponentImpl, FileChannel ciphertextChannelParam,
        EffectiveOpenOptions optionsParam, ChannelCloseListener listenerParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;
      this.openCryptoFileComponentImpl = openCryptoFileComponentImpl;

      initialize(ciphertextChannelParam, optionsParam, listenerParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final FileChannel ciphertextChannelParam,
        final EffectiveOpenOptions optionsParam, final ChannelCloseListener listenerParam) {
      this.ciphertextChannelProvider = InstanceFactory.create(ciphertextChannelParam);
      this.optionsProvider = InstanceFactory.create(optionsParam);
      this.listenerProvider = InstanceFactory.create(listenerParam);
      this.cleartextFileChannelProvider = DoubleCheck.provider(CleartextFileChannel_Factory.create(ciphertextChannelProvider, openCryptoFileComponentImpl.fileHeaderHolderProvider, openCryptoFileComponentImpl.provideReadWriteLockProvider, cryptoFileSystemComponentImpl.cryptorProvider, openCryptoFileComponentImpl.chunkCacheProvider, cryptoFileSystemComponentImpl.bufferPoolProvider, optionsProvider, openCryptoFileComponentImpl.provideFileSizeProvider, openCryptoFileComponentImpl.provideLastModifiedDateProvider, openCryptoFileComponentImpl.provideCurrentPathProvider, openCryptoFileComponentImpl.exceptionsDuringWriteProvider, listenerProvider, cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider));
    }

    @Override
    public CleartextFileChannel channel() {
      return cleartextFileChannelProvider.get();
    }
  }

  private static final class OpenCryptoFileComponentImpl implements OpenCryptoFileComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final OpenCryptoFileComponentImpl openCryptoFileComponentImpl = this;

    private Provider<FileCloseListener> onCloseListenerProvider;

    @SuppressWarnings("rawtypes")
    private Provider chunkIOProvider;

    private Provider<Path> pathProvider;

    private Provider<AtomicReference<Path>> provideCurrentPathProvider;

    private Provider<FileHeaderHolder> fileHeaderHolderProvider;

    @SuppressWarnings("rawtypes")
    private Provider chunkLoaderProvider;

    @SuppressWarnings("rawtypes")
    private Provider chunkSaverProvider;

    private Provider<ExceptionsDuringWrite> exceptionsDuringWriteProvider;

    private Provider<ChunkCache> chunkCacheProvider;

    private Provider<AtomicLong> provideFileSizeProvider;

    private Provider<AtomicReference<Instant>> provideLastModifiedDateProvider;

    private Provider<OpenCryptoFileComponent> openCryptoFileComponentProvider;

    private Provider<OpenCryptoFile> openCryptoFileProvider;

    private Provider<ReadWriteLock> provideReadWriteLockProvider;

    private OpenCryptoFileComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl,
        OpenCryptoFileModule openCryptoFileModuleParam, Path pathParam,
        FileCloseListener onCloseListenerParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;

      initialize(openCryptoFileModuleParam, pathParam, onCloseListenerParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final OpenCryptoFileModule openCryptoFileModuleParam,
        final Path pathParam, final FileCloseListener onCloseListenerParam) {
      this.onCloseListenerProvider = InstanceFactory.create(onCloseListenerParam);
      this.chunkIOProvider = DoubleCheck.provider(ChunkIO_Factory.create());
      this.pathProvider = InstanceFactory.create(pathParam);
      this.provideCurrentPathProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideCurrentPathFactory.create(openCryptoFileModuleParam, pathProvider));
      this.fileHeaderHolderProvider = DoubleCheck.provider(FileHeaderHolder_Factory.create(cryptoFileSystemComponentImpl.cryptorProvider, provideCurrentPathProvider));
      this.chunkLoaderProvider = DoubleCheck.provider(ChunkLoader_Factory.create(cryptoFileSystemComponentImpl.cryptorProvider, chunkIOProvider, fileHeaderHolderProvider, cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, cryptoFileSystemComponentImpl.bufferPoolProvider));
      this.chunkSaverProvider = DoubleCheck.provider(ChunkSaver_Factory.create(cryptoFileSystemComponentImpl.cryptorProvider, chunkIOProvider, fileHeaderHolderProvider, cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, cryptoFileSystemComponentImpl.bufferPoolProvider));
      this.exceptionsDuringWriteProvider = DoubleCheck.provider(ExceptionsDuringWrite_Factory.create());
      this.chunkCacheProvider = DoubleCheck.provider(ChunkCache_Factory.create(chunkLoaderProvider, chunkSaverProvider, cryptoFileSystemComponentImpl.cryptoFileSystemStatsProvider, cryptoFileSystemComponentImpl.bufferPoolProvider, exceptionsDuringWriteProvider));
      this.provideFileSizeProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideFileSizeFactory.create(openCryptoFileModuleParam));
      this.provideLastModifiedDateProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideLastModifiedDateFactory.create(openCryptoFileModuleParam, pathProvider));
      this.openCryptoFileComponentProvider = InstanceFactory.create((OpenCryptoFileComponent) openCryptoFileComponentImpl);
      this.openCryptoFileProvider = DoubleCheck.provider(OpenCryptoFile_Factory.create(onCloseListenerProvider, chunkCacheProvider, cryptoFileSystemComponentImpl.cryptorProvider, fileHeaderHolderProvider, chunkIOProvider, provideCurrentPathProvider, provideFileSizeProvider, provideLastModifiedDateProvider, openCryptoFileComponentProvider));
      this.provideReadWriteLockProvider = DoubleCheck.provider(OpenCryptoFileModule_ProvideReadWriteLockFactory.create(openCryptoFileModuleParam));
    }

    @Override
    public OpenCryptoFile openCryptoFile() {
      return openCryptoFileProvider.get();
    }

    @Override
    public ChannelComponent.Factory newChannelComponent() {
      return new ChannelComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl, openCryptoFileComponentImpl);
    }
  }

  private static final class DirectoryStreamComponentImpl implements DirectoryStreamComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final DirectoryStreamComponentImpl directoryStreamComponentImpl = this;

    private Provider<String> dirIdProvider;

    private Provider<DirectoryStream<Path>> ciphertextDirectoryStreamProvider;

    private Provider<Path> cleartextPathProvider;

    private Provider<DirectoryStream.Filter<? super Path>> filterProvider;

    private Provider<Consumer<CryptoDirectoryStream>> onCloseProvider;

    @SuppressWarnings("rawtypes")
    private Provider c9rDecryptorProvider;

    @SuppressWarnings("rawtypes")
    private Provider c9rConflictResolverProvider;

    @SuppressWarnings("rawtypes")
    private Provider c9rProcessorProvider;

    @SuppressWarnings("rawtypes")
    private Provider c9sInflatorProvider;

    @SuppressWarnings("rawtypes")
    private Provider c9sProcessorProvider;

    @SuppressWarnings("rawtypes")
    private Provider brokenDirectoryFilterProvider;

    @SuppressWarnings("rawtypes")
    private Provider nodeProcessorProvider;

    private Provider<CryptoDirectoryStream> cryptoDirectoryStreamProvider;

    private DirectoryStreamComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path cleartextPathParam,
        String dirIdParam, DirectoryStream<Path> ciphertextDirectoryStreamParam,
        DirectoryStream.Filter<? super Path> filterParam,
        Consumer<CryptoDirectoryStream> onCloseParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;

      initialize(cleartextPathParam, dirIdParam, ciphertextDirectoryStreamParam, filterParam, onCloseParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final Path cleartextPathParam, final String dirIdParam,
        final DirectoryStream<Path> ciphertextDirectoryStreamParam,
        final DirectoryStream.Filter<? super Path> filterParam,
        final Consumer<CryptoDirectoryStream> onCloseParam) {
      this.dirIdProvider = InstanceFactory.create(dirIdParam);
      this.ciphertextDirectoryStreamProvider = InstanceFactory.create(ciphertextDirectoryStreamParam);
      this.cleartextPathProvider = InstanceFactory.create(cleartextPathParam);
      this.filterProvider = InstanceFactory.create(filterParam);
      this.onCloseProvider = InstanceFactory.create(onCloseParam);
      this.c9rDecryptorProvider = DoubleCheck.provider(C9rDecryptor_Factory.create(cryptoFileSystemComponentImpl.cryptorProvider, dirIdProvider));
      this.c9rConflictResolverProvider = DoubleCheck.provider(C9rConflictResolver_Factory.create(cryptoFileSystemComponentImpl.cryptorProvider, dirIdProvider, cryptoFileSystemComponentImpl.vaultConfigProvider));
      this.c9rProcessorProvider = DoubleCheck.provider(C9rProcessor_Factory.create(c9rDecryptorProvider, c9rConflictResolverProvider));
      this.c9sInflatorProvider = DoubleCheck.provider(C9sInflator_Factory.create(cryptoFileSystemComponentImpl.longFileNameProvider, cryptoFileSystemComponentImpl.cryptorProvider, dirIdProvider));
      this.c9sProcessorProvider = DoubleCheck.provider(C9sProcessor_Factory.create(c9sInflatorProvider));
      this.brokenDirectoryFilterProvider = DoubleCheck.provider(BrokenDirectoryFilter_Factory.create(cryptoFileSystemComponentImpl.cryptoPathMapperProvider));
      this.nodeProcessorProvider = DoubleCheck.provider(NodeProcessor_Factory.create(c9rProcessorProvider, c9sProcessorProvider, brokenDirectoryFilterProvider));
      this.cryptoDirectoryStreamProvider = DoubleCheck.provider(CryptoDirectoryStream_Factory.create(dirIdProvider, ciphertextDirectoryStreamProvider, cleartextPathProvider, filterProvider, onCloseProvider, nodeProcessorProvider));
    }

    @Override
    public CryptoDirectoryStream directoryStream() {
      return cryptoDirectoryStreamProvider.get();
    }
  }

  private static final class AttributeComponentImpl implements AttributeComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final AttributeComponentImpl attributeComponentImpl = this;

    private Provider<BasicFileAttributes> ciphertextAttributesProvider;

    private Provider<CiphertextFileType> ciphertextFileTypeProvider;

    private Provider<Path> ciphertextPathProvider;

    private Provider<Optional<OpenCryptoFile>> provideOpenCryptoFileProvider;

    private Provider<BasicFileAttributes> provideAttributesProvider;

    private AttributeComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, Path ciphertextPathParam,
        CiphertextFileType ciphertextFileTypeParam, BasicFileAttributes ciphertextAttributesParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;

      initialize(ciphertextPathParam, ciphertextFileTypeParam, ciphertextAttributesParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final Path ciphertextPathParam,
        final CiphertextFileType ciphertextFileTypeParam,
        final BasicFileAttributes ciphertextAttributesParam) {
      this.ciphertextAttributesProvider = InstanceFactory.create(ciphertextAttributesParam);
      this.ciphertextFileTypeProvider = InstanceFactory.create(ciphertextFileTypeParam);
      this.ciphertextPathProvider = InstanceFactory.create(ciphertextPathParam);
      this.provideOpenCryptoFileProvider = DoubleCheck.provider(AttributeModule_ProvideOpenCryptoFileFactory.create(cryptoFileSystemComponentImpl.openCryptoFilesProvider, ciphertextPathProvider));
      this.provideAttributesProvider = DoubleCheck.provider(AttributeModule_ProvideAttributesFactory.create(ciphertextAttributesProvider, ciphertextFileTypeProvider, ciphertextPathProvider, cryptoFileSystemComponentImpl.cryptorProvider, provideOpenCryptoFileProvider, cryptoFileSystemComponentImpl.cryptoFileSystemPropertiesProvider));
    }

    @Override
    public BasicFileAttributes attributes() {
      return provideAttributesProvider.get();
    }
  }

  private static final class AttributeViewComponentImpl implements AttributeViewComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl;

    private final AttributeViewComponentImpl attributeViewComponentImpl = this;

    private Provider<CryptoPath> cleartextPathProvider;

    private Provider<LinkOption[]> linkOptionsProvider;

    @SuppressWarnings("rawtypes")
    private Provider cryptoBasicFileAttributeViewProvider;

    @SuppressWarnings("rawtypes")
    private Provider cryptoPosixFileAttributeViewProvider;

    @SuppressWarnings("rawtypes")
    private Provider cryptoDosFileAttributeViewProvider;

    @SuppressWarnings("rawtypes")
    private Provider cryptoFileOwnerAttributeViewProvider;

    private Provider<Map<Class<?>, Provider<FileAttributeView>>> mapOfClassOfAndProviderOfFileAttributeViewProvider;

    private Provider<Class<? extends FileAttributeView>> typeProvider;

    private Provider<Optional<FileAttributeView>> provideAttributeViewProvider;

    private AttributeViewComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl, CryptoPath cleartextPathParam,
        Class<? extends FileAttributeView> typeParam, LinkOption[] linkOptionsParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;
      this.cryptoFileSystemComponentImpl = cryptoFileSystemComponentImpl;

      initialize(cleartextPathParam, typeParam, linkOptionsParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final CryptoPath cleartextPathParam,
        final Class<? extends FileAttributeView> typeParam, final LinkOption[] linkOptionsParam) {
      this.cleartextPathProvider = InstanceFactory.create(cleartextPathParam);
      this.linkOptionsProvider = InstanceFactory.create(linkOptionsParam);
      this.cryptoBasicFileAttributeViewProvider = DoubleCheck.provider(CryptoBasicFileAttributeView_Factory.create(cleartextPathProvider, cryptoFileSystemComponentImpl.cryptoPathMapperProvider, linkOptionsProvider, cryptoFileSystemComponentImpl.symlinksProvider, cryptoFileSystemComponentImpl.openCryptoFilesProvider, cryptoFileSystemComponentImpl.attributeProvider, cryptoFileSystemComponentImpl.readonlyFlagProvider));
      this.cryptoPosixFileAttributeViewProvider = DoubleCheck.provider(CryptoPosixFileAttributeView_Factory.create(cleartextPathProvider, cryptoFileSystemComponentImpl.cryptoPathMapperProvider, linkOptionsProvider, cryptoFileSystemComponentImpl.symlinksProvider, cryptoFileSystemComponentImpl.openCryptoFilesProvider, cryptoFileSystemComponentImpl.attributeProvider, cryptoFileSystemComponentImpl.readonlyFlagProvider));
      this.cryptoDosFileAttributeViewProvider = DoubleCheck.provider(CryptoDosFileAttributeView_Factory.create(cleartextPathProvider, cryptoFileSystemComponentImpl.cryptoPathMapperProvider, linkOptionsProvider, cryptoFileSystemComponentImpl.symlinksProvider, cryptoFileSystemComponentImpl.openCryptoFilesProvider, cryptoFileSystemComponentImpl.attributeProvider, cryptoFileSystemComponentImpl.readonlyFlagProvider));
      this.cryptoFileOwnerAttributeViewProvider = DoubleCheck.provider(CryptoFileOwnerAttributeView_Factory.create(cleartextPathProvider, cryptoFileSystemComponentImpl.cryptoPathMapperProvider, linkOptionsProvider, cryptoFileSystemComponentImpl.symlinksProvider, cryptoFileSystemComponentImpl.openCryptoFilesProvider, cryptoFileSystemComponentImpl.readonlyFlagProvider));
      this.mapOfClassOfAndProviderOfFileAttributeViewProvider = MapProviderFactory.<Class<?>, FileAttributeView>builder(4).put(BasicFileAttributeView.class, cryptoBasicFileAttributeViewProvider).put(PosixFileAttributeView.class, cryptoPosixFileAttributeViewProvider).put(DosFileAttributeView.class, cryptoDosFileAttributeViewProvider).put(FileOwnerAttributeView.class, cryptoFileOwnerAttributeViewProvider).build();
      this.typeProvider = InstanceFactory.create(typeParam);
      this.provideAttributeViewProvider = DoubleCheck.provider(AttributeViewModule_ProvideAttributeViewFactory.create(mapOfClassOfAndProviderOfFileAttributeViewProvider, typeProvider));
    }

    @Override
    public Optional<FileAttributeView> attributeView() {
      return provideAttributeViewProvider.get();
    }
  }

  private static final class CryptoFileSystemComponentImpl implements CryptoFileSystemComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl;

    private final CryptoFileSystemComponentImpl cryptoFileSystemComponentImpl = this;

    private Provider<CryptoFileSystemProvider> providerProvider;

    private Provider<Path> pathToVaultProvider;

    private Provider<Cryptor> cryptorProvider;

    private Provider<Optional<FileStore>> provideNativeFileStoreProvider;

    private Provider<CryptoFileSystemProperties> cryptoFileSystemPropertiesProvider;

    private Provider<ReadonlyFlag> readonlyFlagProvider;

    private Provider<CryptoFileStore> cryptoFileStoreProvider;

    private Provider<CryptoFileSystemStats> cryptoFileSystemStatsProvider;

    private Provider<DirectoryIdLoader> directoryIdLoaderProvider;

    private Provider<DirectoryIdProvider> directoryIdProvider;

    private Provider<LongFileNameProvider> longFileNameProvider;

    private Provider<VaultConfig> vaultConfigProvider;

    private Provider<CryptoPathMapper> cryptoPathMapperProvider;

    private Provider<OpenCryptoFileComponent.Factory> openCryptoFileComponentFactoryProvider;

    private Provider<OpenCryptoFiles> openCryptoFilesProvider;

    private Provider<Symlinks> symlinksProvider;

    private Provider<CryptoPathFactory> cryptoPathFactoryProvider;

    private Provider<DirectoryStreamComponent.Factory> directoryStreamComponentFactoryProvider;

    private Provider<DirectoryStreamFactory> directoryStreamFactoryProvider;

    private Provider<DirectoryIdBackup> directoryIdBackupProvider;

    private Provider<AttributeComponent.Factory> attributeComponentFactoryProvider;

    private Provider<AttributeProvider> attributeProvider;

    private Provider<AttributeViewComponent.Factory> attributeViewComponentFactoryProvider;

    private Provider<AttributeViewProvider> attributeViewProvider;

    private Provider<AttributeByNameProvider> attributeByNameProvider;

    private Provider<CiphertextDirectoryDeleter> ciphertextDirectoryDeleterProvider;

    private Provider<CryptoFileSystemImpl> cryptoFileSystemImplProvider;

    private Provider<BufferPool> bufferPoolProvider;

    private CryptoFileSystemComponentImpl(
        CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl,
        CryptoFileSystemModule cryptoFileSystemModuleParam, Cryptor cryptorParam,
        VaultConfig vaultConfigParam, CryptoFileSystemProvider providerParam, Path pathToVaultParam,
        CryptoFileSystemProperties cryptoFileSystemPropertiesParam) {
      this.cryptoFileSystemProviderComponentImpl = cryptoFileSystemProviderComponentImpl;

      initialize(cryptoFileSystemModuleParam, cryptorParam, vaultConfigParam, providerParam, pathToVaultParam, cryptoFileSystemPropertiesParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final CryptoFileSystemModule cryptoFileSystemModuleParam,
        final Cryptor cryptorParam, final VaultConfig vaultConfigParam,
        final CryptoFileSystemProvider providerParam, final Path pathToVaultParam,
        final CryptoFileSystemProperties cryptoFileSystemPropertiesParam) {
      this.providerProvider = InstanceFactory.create(providerParam);
      this.pathToVaultProvider = InstanceFactory.create(pathToVaultParam);
      this.cryptorProvider = InstanceFactory.create(cryptorParam);
      this.provideNativeFileStoreProvider = DoubleCheck.provider(CryptoFileSystemModule_ProvideNativeFileStoreFactory.create(cryptoFileSystemModuleParam, pathToVaultProvider));
      this.cryptoFileSystemPropertiesProvider = InstanceFactory.create(cryptoFileSystemPropertiesParam);
      this.readonlyFlagProvider = DoubleCheck.provider(ReadonlyFlag_Factory.create(cryptoFileSystemPropertiesProvider));
      this.cryptoFileStoreProvider = DoubleCheck.provider(CryptoFileStore_Factory.create(provideNativeFileStoreProvider, readonlyFlagProvider));
      this.cryptoFileSystemStatsProvider = DoubleCheck.provider(CryptoFileSystemStats_Factory.create());
      this.directoryIdLoaderProvider = DoubleCheck.provider(DirectoryIdLoader_Factory.create());
      this.directoryIdProvider = DoubleCheck.provider(DirectoryIdProvider_Factory.create(directoryIdLoaderProvider));
      this.longFileNameProvider = DoubleCheck.provider(LongFileNameProvider_Factory.create(readonlyFlagProvider));
      this.vaultConfigProvider = InstanceFactory.create(vaultConfigParam);
      this.cryptoPathMapperProvider = DoubleCheck.provider(CryptoPathMapper_Factory.create(pathToVaultProvider, cryptorProvider, directoryIdProvider, longFileNameProvider, vaultConfigProvider));
      this.openCryptoFileComponentFactoryProvider = new Provider<OpenCryptoFileComponent.Factory>() {
        @Override
        public OpenCryptoFileComponent.Factory get() {
          return new OpenCryptoFileComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
        }
      };
      this.openCryptoFilesProvider = DoubleCheck.provider(OpenCryptoFiles_Factory.create(openCryptoFileComponentFactoryProvider));
      this.symlinksProvider = DoubleCheck.provider(Symlinks_Factory.create(cryptoPathMapperProvider, longFileNameProvider, openCryptoFilesProvider, readonlyFlagProvider));
      this.cryptoPathFactoryProvider = DoubleCheck.provider(CryptoPathFactory_Factory.create(symlinksProvider));
      this.directoryStreamComponentFactoryProvider = new Provider<DirectoryStreamComponent.Factory>() {
        @Override
        public DirectoryStreamComponent.Factory get() {
          return new DirectoryStreamComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
        }
      };
      this.directoryStreamFactoryProvider = DoubleCheck.provider(DirectoryStreamFactory_Factory.create(cryptoPathMapperProvider, directoryStreamComponentFactoryProvider));
      this.directoryIdBackupProvider = DoubleCheck.provider(DirectoryIdBackup_Factory.create(cryptorProvider));
      this.attributeComponentFactoryProvider = new Provider<AttributeComponent.Factory>() {
        @Override
        public AttributeComponent.Factory get() {
          return new AttributeComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
        }
      };
      this.attributeProvider = DoubleCheck.provider(AttributeProvider_Factory.create(attributeComponentFactoryProvider, cryptoPathMapperProvider, symlinksProvider));
      this.attributeViewComponentFactoryProvider = new Provider<AttributeViewComponent.Factory>() {
        @Override
        public AttributeViewComponent.Factory get() {
          return new AttributeViewComponentFactory(cryptoFileSystemProviderComponentImpl, cryptoFileSystemComponentImpl);
        }
      };
      this.attributeViewProvider = DoubleCheck.provider(AttributeViewProvider_Factory.create(attributeViewComponentFactoryProvider));
      this.attributeByNameProvider = DoubleCheck.provider(AttributeByNameProvider_Factory.create(attributeProvider, attributeViewProvider));
      this.ciphertextDirectoryDeleterProvider = DoubleCheck.provider(CiphertextDirectoryDeleter_Factory.create(directoryStreamFactoryProvider));
      this.cryptoFileSystemImplProvider = DoubleCheck.provider(CryptoFileSystemImpl_Factory.create(providerProvider, cryptoFileSystemProviderComponentImpl.cryptoFileSystemsProvider, pathToVaultProvider, cryptorProvider, cryptoFileStoreProvider, cryptoFileSystemStatsProvider, cryptoPathMapperProvider, cryptoPathFactoryProvider, cryptoFileSystemProviderComponentImpl.pathMatcherFactoryProvider, directoryStreamFactoryProvider, directoryIdProvider, directoryIdBackupProvider, attributeProvider, attributeByNameProvider, attributeViewProvider, openCryptoFilesProvider, symlinksProvider, cryptoFileSystemProviderComponentImpl.finallyUtilProvider, ciphertextDirectoryDeleterProvider, readonlyFlagProvider, cryptoFileSystemPropertiesProvider));
      this.bufferPoolProvider = DoubleCheck.provider(BufferPool_Factory.create(cryptorProvider));
    }

    @Override
    public CryptoFileSystemImpl cryptoFileSystem() {
      return cryptoFileSystemImplProvider.get();
    }
  }

  private static final class CryptoFileSystemProviderComponentImpl implements CryptoFileSystemProviderComponent {
    private final CryptoFileSystemProviderComponentImpl cryptoFileSystemProviderComponentImpl = this;

    private Provider<CryptoFileSystemComponent.Factory> cryptoFileSystemComponentFactoryProvider;

    private Provider<FileSystemCapabilityChecker> fileSystemCapabilityCheckerProvider;

    private Provider<SecureRandom> csprngProvider;

    private Provider<CryptoFileSystems> cryptoFileSystemsProvider;

    private Provider<CopyOperation> copyOperationProvider;

    private Provider<MoveOperation> moveOperationProvider;

    private Provider<GlobToRegexConverter> globToRegexConverterProvider;

    private Provider<PathMatcherFactory> pathMatcherFactoryProvider;

    private Provider<FinallyUtil> finallyUtilProvider;

    private CryptoFileSystemProviderComponentImpl(SecureRandom csprngParam) {

      initialize(csprngParam);

    }

    @SuppressWarnings("unchecked")
    private void initialize(final SecureRandom csprngParam) {
      this.cryptoFileSystemComponentFactoryProvider = new Provider<CryptoFileSystemComponent.Factory>() {
        @Override
        public CryptoFileSystemComponent.Factory get() {
          return new CryptoFileSystemComponentFactory(cryptoFileSystemProviderComponentImpl);
        }
      };
      this.fileSystemCapabilityCheckerProvider = DoubleCheck.provider(FileSystemCapabilityChecker_Factory.create());
      this.csprngProvider = InstanceFactory.create(csprngParam);
      this.cryptoFileSystemsProvider = DoubleCheck.provider(CryptoFileSystems_Factory.create(cryptoFileSystemComponentFactoryProvider, fileSystemCapabilityCheckerProvider, csprngProvider));
      this.copyOperationProvider = DoubleCheck.provider(CopyOperation_Factory.create());
      this.moveOperationProvider = DoubleCheck.provider(MoveOperation_Factory.create(copyOperationProvider));
      this.globToRegexConverterProvider = DoubleCheck.provider(GlobToRegexConverter_Factory.create());
      this.pathMatcherFactoryProvider = DoubleCheck.provider(PathMatcherFactory_Factory.create(globToRegexConverterProvider));
      this.finallyUtilProvider = DoubleCheck.provider(FinallyUtil_Factory.create());
    }

    @Override
    public CryptoFileSystems fileSystems() {
      return cryptoFileSystemsProvider.get();
    }

    @Override
    public MoveOperation moveOperation() {
      return moveOperationProvider.get();
    }

    @Override
    public CopyOperation copyOperation() {
      return copyOperationProvider.get();
    }
  }
}
