/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CiphertextFilePath;
import org.cryptomator.cryptofs.CryptoFileStore;
import org.cryptomator.cryptofs.CryptoFileSystem;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.CryptoFileSystems;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathFactory;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.DirectoryIdProvider;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.FileNameTooLongException;
import org.cryptomator.cryptofs.PathMatcherFactory;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AttributeByNameProvider;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;
import org.cryptomator.cryptofs.attr.AttributeViewType;
import org.cryptomator.cryptofs.common.ArrayUtils;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.common.DeletingFileVisitor;
import org.cryptomator.cryptofs.common.FinallyUtil;
import org.cryptomator.cryptofs.dir.CiphertextDirectoryDeleter;
import org.cryptomator.cryptofs.dir.DirectoryStreamFactory;
import org.cryptomator.cryptofs.dir.DirectoryStreamFilters;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptolib.api.Cryptor;

@CryptoFileSystemScoped
class CryptoFileSystemImpl
extends CryptoFileSystem {
    private final CryptoFileSystemProvider provider;
    private final CryptoFileSystems cryptoFileSystems;
    private final Path pathToVault;
    private final Cryptor cryptor;
    private final CryptoFileStore fileStore;
    private final CryptoFileSystemStats stats;
    private final CryptoPathMapper cryptoPathMapper;
    private final CryptoPathFactory cryptoPathFactory;
    private final PathMatcherFactory pathMatcherFactory;
    private final DirectoryStreamFactory directoryStreamFactory;
    private final DirectoryIdProvider dirIdProvider;
    private final DirectoryIdBackup dirIdBackup;
    private final AttributeProvider fileAttributeProvider;
    private final AttributeByNameProvider fileAttributeByNameProvider;
    private final AttributeViewProvider fileAttributeViewProvider;
    private final OpenCryptoFiles openCryptoFiles;
    private final Symlinks symlinks;
    private final FinallyUtil finallyUtil;
    private final CiphertextDirectoryDeleter ciphertextDirDeleter;
    private final ReadonlyFlag readonlyFlag;
    private final CryptoFileSystemProperties fileSystemProperties;
    private final CryptoPath rootPath;
    private final CryptoPath emptyPath;
    private volatile boolean open = true;

    @Inject
    public CryptoFileSystemImpl(CryptoFileSystemProvider provider, CryptoFileSystems cryptoFileSystems, @PathToVault Path pathToVault, Cryptor cryptor, CryptoFileStore fileStore, CryptoFileSystemStats stats, CryptoPathMapper cryptoPathMapper, CryptoPathFactory cryptoPathFactory, PathMatcherFactory pathMatcherFactory, DirectoryStreamFactory directoryStreamFactory, DirectoryIdProvider dirIdProvider, DirectoryIdBackup dirIdBackup, AttributeProvider fileAttributeProvider, AttributeByNameProvider fileAttributeByNameProvider, AttributeViewProvider fileAttributeViewProvider, OpenCryptoFiles openCryptoFiles, Symlinks symlinks, FinallyUtil finallyUtil, CiphertextDirectoryDeleter ciphertextDirDeleter, ReadonlyFlag readonlyFlag, CryptoFileSystemProperties fileSystemProperties) {
        this.provider = provider;
        this.cryptoFileSystems = cryptoFileSystems;
        this.pathToVault = pathToVault;
        this.cryptor = cryptor;
        this.fileStore = fileStore;
        this.stats = stats;
        this.cryptoPathMapper = cryptoPathMapper;
        this.cryptoPathFactory = cryptoPathFactory;
        this.pathMatcherFactory = pathMatcherFactory;
        this.directoryStreamFactory = directoryStreamFactory;
        this.dirIdProvider = dirIdProvider;
        this.dirIdBackup = dirIdBackup;
        this.fileAttributeProvider = fileAttributeProvider;
        this.fileAttributeByNameProvider = fileAttributeByNameProvider;
        this.fileAttributeViewProvider = fileAttributeViewProvider;
        this.openCryptoFiles = openCryptoFiles;
        this.symlinks = symlinks;
        this.finallyUtil = finallyUtil;
        this.ciphertextDirDeleter = ciphertextDirDeleter;
        this.readonlyFlag = readonlyFlag;
        this.fileSystemProperties = fileSystemProperties;
        this.rootPath = cryptoPathFactory.rootFor(this);
        this.emptyPath = cryptoPathFactory.emptyFor(this);
    }

    @Override
    public Path getPathToVault() {
        return this.pathToVault;
    }

    @Override
    public Path getCiphertextPath(Path cleartextPath) throws IOException {
        CryptoPath p = CryptoPath.castAndAssertAbsolute(cleartextPath);
        CiphertextFileType nodeType = this.cryptoPathMapper.getCiphertextFileType(p);
        if (nodeType == CiphertextFileType.DIRECTORY) {
            return this.cryptoPathMapper.getCiphertextDir((CryptoPath)p).path;
        }
        CiphertextFilePath cipherFile = this.cryptoPathMapper.getCiphertextFilePath(p);
        if (nodeType == CiphertextFileType.SYMLINK) {
            return cipherFile.getSymlinkFilePath();
        }
        return cipherFile.getFilePath();
    }

    @Override
    public CryptoFileSystemStats getStats() {
        return this.stats;
    }

    @Override
    public CryptoFileSystemProvider provider() {
        this.assertOpen();
        return this.provider;
    }

    @Override
    public boolean isReadOnly() {
        this.assertOpen();
        return this.readonlyFlag.isSet();
    }

    @Override
    public String getSeparator() {
        this.assertOpen();
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        this.assertOpen();
        return Collections.singleton(this.getRootPath());
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        this.assertOpen();
        return Collections.singleton(this.fileStore);
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.finallyUtil.guaranteeInvocationOf(() -> this.cryptoFileSystems.remove(this), () -> this.openCryptoFiles.close(), () -> this.directoryStreamFactory.close(), () -> this.cryptor.destroy());
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        this.assertOpen();
        return this.fileStore.supportedFileAttributeViewTypes().stream().map(AttributeViewType::getViewName).collect(Collectors.toSet());
    }

    @Override
    public CryptoPath getPath(String first, String ... more) {
        this.assertOpen();
        return this.cryptoPathFactory.getPath(this, first, more);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.assertOpen();
        return this.pathMatcherFactory.pathMatcherFrom(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        this.assertOpen();
        throw new UnsupportedOperationException();
    }

    void setAttribute(CryptoPath cleartextPath, String attribute, Object value, LinkOption ... options) throws IOException {
        this.readonlyFlag.assertWritable();
        this.fileAttributeByNameProvider.setAttribute(cleartextPath, attribute, value, options);
    }

    Map<String, Object> readAttributes(CryptoPath cleartextPath, String attributes, LinkOption ... options) throws IOException {
        this.stats.incrementAccesses();
        return this.fileAttributeByNameProvider.readAttributes(cleartextPath, attributes, options);
    }

    <A extends BasicFileAttributes> A readAttributes(CryptoPath cleartextPath, Class<A> type, LinkOption ... options) throws IOException {
        this.stats.incrementAccesses();
        return this.fileAttributeProvider.readAttributes(cleartextPath, type, options);
    }

    <V extends FileAttributeView> V getFileAttributeView(CryptoPath cleartextPath, Class<V> type, LinkOption ... options) {
        if (this.fileStore.supportsFileAttributeView(type)) {
            return this.fileAttributeViewProvider.getAttributeView(cleartextPath, type, options);
        }
        return null;
    }

    void checkAccess(CryptoPath cleartextPath, AccessMode ... modes) throws IOException {
        if (this.fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
            Set<PosixFilePermission> permissions = this.readAttributes(cleartextPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            boolean accessDenied = Arrays.stream(modes).anyMatch(accessMode -> !this.hasAccess(permissions, (AccessMode)((Object)accessMode)));
            if (accessDenied) {
                throw new AccessDeniedException(cleartextPath.toString());
            }
        } else if (this.fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
            DosFileAttributes attrs = this.readAttributes(cleartextPath, DosFileAttributes.class, new LinkOption[0]);
            if (ArrayUtils.contains((Object[])modes, (Object)AccessMode.WRITE) && attrs.isReadOnly()) {
                throw new AccessDeniedException(cleartextPath.toString(), null, "read only file");
            }
        } else {
            this.readAttributes(cleartextPath, BasicFileAttributes.class, new LinkOption[0]);
        }
    }

    private boolean hasAccess(Set<PosixFilePermission> permissions, AccessMode accessMode) {
        return switch (accessMode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.READ -> permissions.contains((Object)PosixFilePermission.OWNER_READ);
            case AccessMode.WRITE -> permissions.contains((Object)PosixFilePermission.OWNER_WRITE);
            case AccessMode.EXECUTE -> permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE);
        };
    }

    boolean isHidden(CryptoPath cleartextPath) throws IOException {
        DosFileAttributeView view = this.getFileAttributeView(cleartextPath, DosFileAttributeView.class, new LinkOption[0]);
        if (view != null) {
            return view.readAttributes().isHidden();
        }
        return false;
    }

    void createDirectory(CryptoPath cleartextDir, FileAttribute<?> ... attrs) throws IOException {
        this.readonlyFlag.assertWritable();
        this.assertCleartextNameLengthAllowed(cleartextDir);
        if (this.rootPath.equals(cleartextDir)) {
            throw new FileAlreadyExistsException(this.rootPath.toString());
        }
        CryptoPath cleartextParentDir = cleartextDir.getParent();
        if (cleartextParentDir == null) {
            return;
        }
        Path ciphertextParentDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextParentDir).path;
        if (!Files.exists(ciphertextParentDir, new LinkOption[0])) {
            throw new NoSuchFileException(cleartextParentDir.toString());
        }
        this.cryptoPathMapper.assertNonExisting(cleartextDir);
        CiphertextFilePath ciphertextPath = this.cryptoPathMapper.getCiphertextFilePath(cleartextDir);
        Path ciphertextDirFile = ciphertextPath.getDirFilePath();
        CryptoPathMapper.CiphertextDirectory ciphertextDir = this.cryptoPathMapper.getCiphertextDir(cleartextDir);
        Files.createDirectory(ciphertextPath.getRawPath(), new FileAttribute[0]);
        try (FileChannel channel = FileChannel.open(ciphertextDirFile, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), attrs);){
            channel.write(StandardCharsets.UTF_8.encode(ciphertextDir.dirId));
        }
        try {
            Files.createDirectories(ciphertextDir.path, new FileAttribute[0]);
            this.dirIdBackup.execute(ciphertextDir);
            ciphertextPath.persistLongFileName();
        }
        catch (IOException e) {
            Files.delete(ciphertextDirFile);
            this.cryptoPathMapper.invalidatePathMapping(cleartextDir);
            this.dirIdProvider.delete(ciphertextDirFile);
            throw e;
        }
    }

    DirectoryStream<Path> newDirectoryStream(CryptoPath cleartextDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.directoryStreamFactory.newDirectoryStream(cleartextDir, filter);
    }

    FileChannel newFileChannel(CryptoPath cleartextPath, Set<? extends OpenOption> optionsSet, FileAttribute<?> ... attrs) throws IOException {
        CiphertextFileType ciphertextFileType;
        EffectiveOpenOptions options = EffectiveOpenOptions.from(optionsSet, this.readonlyFlag);
        if (options.writable()) {
            this.readonlyFlag.assertWritable();
        }
        try {
            ciphertextFileType = this.cryptoPathMapper.getCiphertextFileType(cleartextPath);
        }
        catch (NoSuchFileException e) {
            if (options.create() || options.createNew()) {
                ciphertextFileType = CiphertextFileType.FILE;
            }
            throw e;
        }
        return switch (ciphertextFileType) {
            default -> throw new IncompatibleClassChangeError();
            case CiphertextFileType.SYMLINK -> this.newFileChannelFromSymlink(cleartextPath, options, attrs);
            case CiphertextFileType.FILE -> this.newFileChannelFromFile(cleartextPath, options, attrs);
            case CiphertextFileType.DIRECTORY -> throw new UnsupportedOperationException("Can not create file channel for " + ciphertextFileType.name());
        };
    }

    private FileChannel newFileChannelFromSymlink(CryptoPath cleartextPath, EffectiveOpenOptions options, FileAttribute<?> ... attrs) throws IOException {
        if (options.noFollowLinks()) {
            throw new UnsupportedOperationException("Unsupported OpenOption LinkOption.NOFOLLOW_LINKS. Can not create file channel for symbolic link.");
        }
        CryptoPath resolvedPath = this.symlinks.resolveRecursively(cleartextPath);
        return this.newFileChannelFromFile(resolvedPath, options, attrs);
    }

    private FileChannel newFileChannelFromFile(CryptoPath cleartextFilePath, EffectiveOpenOptions options, FileAttribute<?> ... attrs) throws IOException {
        if (options.create() || options.createNew()) {
            this.assertCleartextNameLengthAllowed(cleartextFilePath);
        }
        CiphertextFilePath ciphertextPath = this.cryptoPathMapper.getCiphertextFilePath(cleartextFilePath);
        Path ciphertextFilePath = ciphertextPath.getFilePath();
        if (options.createNew() && this.openCryptoFiles.get(ciphertextFilePath).isPresent()) {
            throw new FileAlreadyExistsException(cleartextFilePath.toString());
        }
        if (ciphertextPath.isShortened() && options.createNew()) {
            Files.createDirectory(ciphertextPath.getRawPath(), new FileAttribute[0]);
        } else if (ciphertextPath.isShortened()) {
            Files.createDirectories(ciphertextPath.getRawPath(), new FileAttribute[0]);
        }
        FileChannel ch = this.openCryptoFiles.getOrCreate(ciphertextFilePath).newFileChannel(options, attrs);
        try {
            if (options.writable()) {
                ciphertextPath.persistLongFileName();
                this.stats.incrementAccessesWritten();
            }
            if (options.readable()) {
                this.stats.incrementAccessesRead();
            }
            this.stats.incrementAccesses();
            return ch;
        }
        catch (Exception e) {
            ch.close();
            throw e;
        }
    }

    void delete(CryptoPath cleartextPath) throws IOException {
        this.readonlyFlag.assertWritable();
        if (this.rootPath.equals(cleartextPath)) {
            throw new FileSystemException("The filesystem root cannot be deleted.");
        }
        CiphertextFileType ciphertextFileType = this.cryptoPathMapper.getCiphertextFileType(cleartextPath);
        CiphertextFilePath ciphertextPath = this.cryptoPathMapper.getCiphertextFilePath(cleartextPath);
        switch (ciphertextFileType) {
            case DIRECTORY: {
                this.deleteDirectory(cleartextPath, ciphertextPath);
                break;
            }
            case SYMLINK: 
            case FILE: {
                this.deleteFileOrSymlink(ciphertextPath);
            }
        }
    }

    private void deleteFileOrSymlink(CiphertextFilePath ciphertextPath) throws IOException {
        this.openCryptoFiles.delete(ciphertextPath.getFilePath());
        Files.walkFileTree(ciphertextPath.getRawPath(), DeletingFileVisitor.INSTANCE);
    }

    private void deleteDirectory(CryptoPath cleartextPath, CiphertextFilePath ciphertextPath) throws IOException {
        Path ciphertextDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextPath).path;
        Path ciphertextDirFile = ciphertextPath.getDirFilePath();
        try {
            this.ciphertextDirDeleter.deleteCiphertextDirIncludingNonCiphertextFiles(ciphertextDir, cleartextPath);
            Files.walkFileTree(ciphertextPath.getRawPath(), DeletingFileVisitor.INSTANCE);
            this.cryptoPathMapper.invalidatePathMapping(cleartextPath);
            this.dirIdProvider.delete(ciphertextDirFile);
        }
        catch (NoSuchFileException e) {
            throw new NoSuchFileException(cleartextPath.toString());
        }
        catch (DirectoryNotEmptyException e) {
            throw new DirectoryNotEmptyException(cleartextPath.toString());
        }
    }

    void copy(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption ... options) throws IOException {
        this.readonlyFlag.assertWritable();
        this.assertCleartextNameLengthAllowed(cleartextTarget);
        if (cleartextSource.equals(cleartextTarget)) {
            return;
        }
        if (this.rootPath.equals(cleartextTarget) && ArrayUtils.contains(options, StandardCopyOption.REPLACE_EXISTING)) {
            throw new FileSystemException("The filesystem root cannot be replaced.");
        }
        CiphertextFileType ciphertextFileType = this.cryptoPathMapper.getCiphertextFileType(cleartextSource);
        if (!ArrayUtils.contains(options, StandardCopyOption.REPLACE_EXISTING)) {
            this.cryptoPathMapper.assertNonExisting(cleartextTarget);
        }
        switch (ciphertextFileType) {
            case SYMLINK: {
                this.copySymlink(cleartextSource, cleartextTarget, options);
                break;
            }
            case FILE: {
                this.copyFile(cleartextSource, cleartextTarget, options);
                break;
            }
            case DIRECTORY: {
                this.copyDirectory(cleartextSource, cleartextTarget, options);
            }
        }
    }

    private void copySymlink(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        if (ArrayUtils.contains(options, LinkOption.NOFOLLOW_LINKS)) {
            CiphertextFilePath ciphertextSourceFile = this.cryptoPathMapper.getCiphertextFilePath(cleartextSource);
            CiphertextFilePath ciphertextTargetFile = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
            CopyOption[] resolvedOptions = (CopyOption[])ArrayUtils.without(options, LinkOption.NOFOLLOW_LINKS).toArray(CopyOption[]::new);
            Files.createDirectories(ciphertextTargetFile.getRawPath(), new FileAttribute[0]);
            Files.copy(ciphertextSourceFile.getSymlinkFilePath(), ciphertextTargetFile.getSymlinkFilePath(), resolvedOptions);
            ciphertextTargetFile.persistLongFileName();
        } else {
            CryptoPath resolvedSource = this.symlinks.resolveRecursively(cleartextSource);
            CryptoPath resolvedTarget = this.symlinks.resolveRecursively(cleartextTarget);
            CopyOption[] resolvedOptions = (CopyOption[])ArrayUtils.with(options, LinkOption.NOFOLLOW_LINKS).toArray(CopyOption[]::new);
            this.copy(resolvedSource, resolvedTarget, resolvedOptions);
        }
    }

    private void copyFile(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        CiphertextFilePath ciphertextSource = this.cryptoPathMapper.getCiphertextFilePath(cleartextSource);
        CiphertextFilePath ciphertextTarget = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
        if (ciphertextTarget.isShortened()) {
            Files.createDirectories(ciphertextTarget.getRawPath(), new FileAttribute[0]);
        }
        Files.copy(ciphertextSource.getFilePath(), ciphertextTarget.getFilePath(), options);
        ciphertextTarget.persistLongFileName();
    }

    private void copyDirectory(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        block11: {
            CiphertextFilePath ciphertextTarget = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
            if (Files.notExists(ciphertextTarget.getRawPath(), new LinkOption[0])) {
                this.createDirectory(cleartextTarget, new FileAttribute[0]);
                ciphertextTarget.persistLongFileName();
            } else {
                if (ArrayUtils.contains(options, StandardCopyOption.REPLACE_EXISTING)) {
                    Path ciphertextTargetDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextTarget).path;
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(ciphertextTargetDir);){
                        if (ds.iterator().hasNext()) {
                            throw new DirectoryNotEmptyException(cleartextTarget.toString());
                        }
                        break block11;
                    }
                }
                throw new FileAlreadyExistsException(cleartextTarget.toString(), null, "Ciphertext file already exists: " + ciphertextTarget);
            }
        }
        if (ArrayUtils.contains(options, StandardCopyOption.COPY_ATTRIBUTES)) {
            Path ciphertextSourceDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextSource).path;
            Path ciphertextTargetDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextTarget).path;
            this.copyAttributes(ciphertextSourceDir, ciphertextTargetDir);
        }
    }

    private void copyAttributes(Path src, Path dst) throws IOException {
        FileAttributeView dstAttrView;
        BasicFileAttributes srcAttrs;
        Set<AttributeViewType> supportedAttributeViewTypes = this.fileStore.supportedFileAttributeViewTypes();
        if (supportedAttributeViewTypes.contains((Object)AttributeViewType.BASIC)) {
            srcAttrs = Files.readAttributes(src, BasicFileAttributes.class, new LinkOption[0]);
            dstAttrView = Files.getFileAttributeView(dst, BasicFileAttributeView.class, new LinkOption[0]);
            dstAttrView.setTimes(srcAttrs.lastModifiedTime(), srcAttrs.lastAccessTime(), srcAttrs.creationTime());
        }
        if (supportedAttributeViewTypes.contains((Object)AttributeViewType.OWNER)) {
            FileOwnerAttributeView srcAttrView = Files.getFileAttributeView(src, FileOwnerAttributeView.class, new LinkOption[0]);
            dstAttrView = Files.getFileAttributeView(dst, FileOwnerAttributeView.class, new LinkOption[0]);
            dstAttrView.setOwner(srcAttrView.getOwner());
        }
        if (supportedAttributeViewTypes.contains((Object)AttributeViewType.POSIX)) {
            srcAttrs = Files.readAttributes(src, PosixFileAttributes.class, new LinkOption[0]);
            dstAttrView = Files.getFileAttributeView(dst, PosixFileAttributeView.class, new LinkOption[0]);
            dstAttrView.setGroup(srcAttrs.group());
            dstAttrView.setPermissions(srcAttrs.permissions());
        }
        if (supportedAttributeViewTypes.contains((Object)AttributeViewType.DOS)) {
            srcAttrs = Files.readAttributes(src, DosFileAttributes.class, new LinkOption[0]);
            dstAttrView = Files.getFileAttributeView(dst, DosFileAttributeView.class, new LinkOption[0]);
            dstAttrView.setArchive(srcAttrs.isArchive());
            dstAttrView.setHidden(srcAttrs.isHidden());
            dstAttrView.setReadOnly(srcAttrs.isReadOnly());
            dstAttrView.setSystem(srcAttrs.isSystem());
        }
    }

    void move(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption ... options) throws IOException {
        this.readonlyFlag.assertWritable();
        this.assertCleartextNameLengthAllowed(cleartextTarget);
        if (this.rootPath.equals(cleartextSource)) {
            throw new FileSystemException("Filesystem root cannot be moved.");
        }
        if (this.rootPath.equals(cleartextTarget)) {
            throw new FileAlreadyExistsException(this.rootPath.toString());
        }
        if (cleartextSource.equals(cleartextTarget)) {
            return;
        }
        CiphertextFileType ciphertextFileType = this.cryptoPathMapper.getCiphertextFileType(cleartextSource);
        if (!ArrayUtils.contains(options, StandardCopyOption.REPLACE_EXISTING)) {
            this.cryptoPathMapper.assertNonExisting(cleartextTarget);
        }
        switch (ciphertextFileType) {
            case SYMLINK: {
                this.moveSymlink(cleartextSource, cleartextTarget, options);
                break;
            }
            case FILE: {
                this.moveFile(cleartextSource, cleartextTarget, options);
                break;
            }
            case DIRECTORY: {
                this.moveDirectory(cleartextSource, cleartextTarget, options);
            }
        }
    }

    private void moveSymlink(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        CiphertextFilePath ciphertextSource = this.cryptoPathMapper.getCiphertextFilePath(cleartextSource);
        CiphertextFilePath ciphertextTarget = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
        try (OpenCryptoFiles.TwoPhaseMove twoPhaseMove = this.openCryptoFiles.prepareMove(ciphertextSource.getRawPath(), ciphertextTarget.getRawPath());){
            Files.move(ciphertextSource.getRawPath(), ciphertextTarget.getRawPath(), options);
            if (ciphertextTarget.isShortened()) {
                ciphertextTarget.persistLongFileName();
            } else {
                Files.deleteIfExists(ciphertextTarget.getInflatedNamePath());
            }
            twoPhaseMove.commit();
        }
    }

    private void moveFile(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        CiphertextFilePath ciphertextSource = this.cryptoPathMapper.getCiphertextFilePath(cleartextSource);
        CiphertextFilePath ciphertextTarget = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
        try (OpenCryptoFiles.TwoPhaseMove twoPhaseMove = this.openCryptoFiles.prepareMove(ciphertextSource.getRawPath(), ciphertextTarget.getRawPath());){
            if (ciphertextTarget.isShortened()) {
                Files.createDirectories(ciphertextTarget.getRawPath(), new FileAttribute[0]);
                ciphertextTarget.persistLongFileName();
            }
            Files.move(ciphertextSource.getFilePath(), ciphertextTarget.getFilePath(), options);
            if (ciphertextSource.isShortened()) {
                Files.walkFileTree(ciphertextSource.getRawPath(), DeletingFileVisitor.INSTANCE);
            }
            twoPhaseMove.commit();
        }
    }

    private void moveDirectory(CryptoPath cleartextSource, CryptoPath cleartextTarget, CopyOption[] options) throws IOException {
        CiphertextFilePath ciphertextSource = this.cryptoPathMapper.getCiphertextFilePath(cleartextSource);
        CiphertextFilePath ciphertextTarget = this.cryptoPathMapper.getCiphertextFilePath(cleartextTarget);
        if (ArrayUtils.contains(options, StandardCopyOption.REPLACE_EXISTING)) {
            if (ArrayUtils.contains(options, StandardCopyOption.ATOMIC_MOVE)) {
                throw new AtomicMoveNotSupportedException(cleartextSource.toString(), cleartextTarget.toString(), "Replacing directories during move requires non-atomic status checks.");
            }
            Path targetCiphertextDirContentDir = this.cryptoPathMapper.getCiphertextDir((CryptoPath)cleartextTarget).path;
            boolean targetCiphertextDirExists = true;
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(targetCiphertextDirContentDir, DirectoryStreamFilters.EXCLUDE_DIR_ID_BACKUP);){
                if (ds.iterator().hasNext()) {
                    throw new DirectoryNotEmptyException(cleartextTarget.toString());
                }
            }
            catch (NoSuchFileException e) {
                targetCiphertextDirExists = false;
            }
            Files.walkFileTree(ciphertextTarget.getRawPath(), DeletingFileVisitor.INSTANCE);
            if (targetCiphertextDirExists) {
                Files.walkFileTree(targetCiphertextDirContentDir, DeletingFileVisitor.INSTANCE);
            }
        }
        Files.move(ciphertextSource.getRawPath(), ciphertextTarget.getRawPath(), options);
        if (ciphertextTarget.isShortened()) {
            ciphertextTarget.persistLongFileName();
        } else {
            Files.deleteIfExists(ciphertextTarget.getInflatedNamePath());
        }
        this.dirIdProvider.move(ciphertextSource.getDirFilePath(), ciphertextTarget.getDirFilePath());
        this.cryptoPathMapper.movePathMapping(cleartextSource, cleartextTarget);
    }

    CryptoFileStore getFileStore() {
        return this.fileStore;
    }

    void createSymbolicLink(CryptoPath cleartextPath, Path target, FileAttribute<?> ... attrs) throws IOException {
        this.assertOpen();
        this.readonlyFlag.assertWritable();
        this.assertCleartextNameLengthAllowed(cleartextPath);
        this.symlinks.createSymbolicLink(cleartextPath, target, attrs);
    }

    CryptoPath readSymbolicLink(CryptoPath cleartextPath) throws IOException {
        this.assertOpen();
        return this.symlinks.readSymbolicLink(cleartextPath);
    }

    CryptoPath getRootPath() {
        return this.rootPath;
    }

    CryptoPath getEmptyPath() {
        return this.emptyPath;
    }

    void assertCleartextNameLengthAllowed(CryptoPath cleartextPath) throws FileNameTooLongException {
        String filename = Optional.ofNullable(cleartextPath.getFileName()).map(CryptoPath::toString).orElse("");
        if (filename.length() > this.fileSystemProperties.maxCleartextNameLength()) {
            throw new FileNameTooLongException(cleartextPath.toString(), this.fileSystemProperties.maxCleartextNameLength());
        }
    }

    void assertOpen() {
        if (!this.open) {
            throw new ClosedFileSystemException();
        }
    }

    public String toString() {
        return String.format("%sCryptoFileSystem(%s)", this.open ? "" : "closed ", this.pathToVault);
    }
}

