/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.attr.AttributeComponent;
import org.cryptomator.cryptofs.attr.AttributeViewComponent;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module(subcomponents={AttributeComponent.class, AttributeViewComponent.class, OpenCryptoFileComponent.class, DirectoryStreamComponent.class})
class CryptoFileSystemModule {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoFileSystemModule.class);

    CryptoFileSystemModule() {
    }

    @Provides
    @CryptoFileSystemScoped
    public Optional<FileStore> provideNativeFileStore(@PathToVault Path pathToVault) {
        try {
            return Optional.of(Files.getFileStore(pathToVault));
        }
        catch (IOException e) {
            LOG.warn("Failed to get file store for " + pathToVault, (Throwable)e);
            return Optional.empty();
        }
    }
}

