/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.cryptomator.cryptofs.EffectiveOpenOptions;
import org.cryptomator.cryptofs.ch.CleartextFileChannel;
import org.cryptomator.cryptofs.fh.ChunkCache;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.CurrentOpenFilePath;
import org.cryptomator.cryptofs.fh.FileCloseListener;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.OpenCryptoFileComponent;
import org.cryptomator.cryptofs.fh.OpenFileModifiedDate;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptofs.fh.OpenFileSize;
import org.cryptomator.cryptolib.api.Cryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OpenFileScoped
public class OpenCryptoFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenCryptoFile.class);
    private final FileCloseListener listener;
    private final AtomicReference<Instant> lastModified;
    private final ChunkCache chunkCache;
    private final Cryptor cryptor;
    private final FileHeaderHolder headerHolder;
    private final ChunkIO chunkIO;
    private final AtomicReference<Path> currentFilePath;
    private final AtomicLong fileSize;
    private final OpenCryptoFileComponent component;
    private final ConcurrentMap<CleartextFileChannel, FileChannel> openChannels = new ConcurrentHashMap<CleartextFileChannel, FileChannel>();

    @Inject
    public OpenCryptoFile(FileCloseListener listener, ChunkCache chunkCache, Cryptor cryptor, FileHeaderHolder headerHolder, ChunkIO chunkIO, @CurrentOpenFilePath AtomicReference<Path> currentFilePath, @OpenFileSize AtomicLong fileSize, @OpenFileModifiedDate AtomicReference<Instant> lastModified, OpenCryptoFileComponent component) {
        this.listener = listener;
        this.chunkCache = chunkCache;
        this.cryptor = cryptor;
        this.headerHolder = headerHolder;
        this.chunkIO = chunkIO;
        this.currentFilePath = currentFilePath;
        this.fileSize = fileSize;
        this.component = component;
        this.lastModified = lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FileChannel newFileChannel(EffectiveOpenOptions options, FileAttribute<?> ... attrs) throws IOException {
        CleartextFileChannel cleartextFileChannel;
        FileChannel ciphertextFileChannel;
        block8: {
            Path path = this.currentFilePath.get();
            if (path == null) {
                throw new IllegalStateException("Cannot create file channel to deleted file");
            }
            ciphertextFileChannel = null;
            cleartextFileChannel = null;
            try {
                ciphertextFileChannel = path.getFileSystem().provider().newFileChannel(path, options.createOpenOptionsForEncryptedFile(), attrs);
                this.initFileHeader(options, ciphertextFileChannel);
                if (options.truncateExisting()) {
                    this.chunkCache.invalidateStale();
                    ciphertextFileChannel.truncate(this.cryptor.fileHeaderCryptor().headerSize());
                    this.fileSize.set(0L);
                }
                this.initFileSize(ciphertextFileChannel);
                cleartextFileChannel = this.component.newChannelComponent().create(ciphertextFileChannel, options, this::channelClosed).channel();
                if (cleartextFileChannel != null) break block8;
                this.closeQuietly(ciphertextFileChannel);
            }
            catch (Throwable throwable) {
                if (cleartextFileChannel == null) {
                    this.closeQuietly(ciphertextFileChannel);
                    if (this.openChannels.isEmpty()) {
                        this.close();
                    }
                }
                throw throwable;
            }
            if (this.openChannels.isEmpty()) {
                this.close();
            }
        }
        assert (cleartextFileChannel != null);
        this.openChannels.put(cleartextFileChannel, ciphertextFileChannel);
        this.chunkIO.registerChannel(ciphertextFileChannel, options.writable());
        return cleartextFileChannel;
    }

    void initFileHeader(EffectiveOpenOptions options, FileChannel ciphertextFileChannel) throws IOException {
        try {
            this.headerHolder.get();
        }
        catch (IllegalStateException e) {
            if (options.createNew() || options.create() && ciphertextFileChannel.size() == 0L) {
                this.headerHolder.createNew();
            }
            this.headerHolder.loadExisting(ciphertextFileChannel);
        }
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initFileSize(FileChannel ciphertextFileChannel) throws IOException {
        if (this.fileSize.get() == -1L) {
            long cleartextSize;
            block4: {
                LOG.trace("First channel for this openFile. Initializing file size...");
                cleartextSize = 0L;
                try {
                    long ciphertextSize = ciphertextFileChannel.size();
                    if (ciphertextSize > 0L) {
                        long payloadSize = ciphertextSize - (long)this.cryptor.fileHeaderCryptor().headerSize();
                        cleartextSize = this.cryptor.fileContentCryptor().cleartextSize(payloadSize);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Invalid cipher text file size. Assuming empty file.", (Throwable)e);
                    if ($assertionsDisabled || cleartextSize == 0L) break block4;
                    throw new AssertionError();
                }
            }
            this.fileSize.compareAndSet(-1L, cleartextSize);
        }
    }

    public Optional<Long> size() {
        long val = this.fileSize.get();
        if (val == -1L) {
            return Optional.empty();
        }
        return Optional.of(val);
    }

    public FileTime getLastModifiedTime() {
        return FileTime.from(this.lastModified.get());
    }

    public void setLastModifiedTime(FileTime lastModifiedTime) {
        this.lastModified.set(lastModifiedTime.toInstant());
    }

    public Path getCurrentFilePath() {
        return this.currentFilePath.get();
    }

    public void updateCurrentFilePath(Path newFilePath) {
        this.currentFilePath.updateAndGet(p -> p == null ? null : newFilePath);
    }

    private synchronized void channelClosed(CleartextFileChannel cleartextFileChannel) throws IOException {
        try {
            FileChannel ciphertextFileChannel = (FileChannel)this.openChannels.remove(cleartextFileChannel);
            if (ciphertextFileChannel != null) {
                this.chunkIO.unregisterChannel(ciphertextFileChannel);
                ciphertextFileChannel.close();
            }
        }
        finally {
            if (this.openChannels.isEmpty()) {
                this.close();
            }
        }
    }

    @Override
    public void close() {
        Path p = this.currentFilePath.get();
        if (p != null) {
            this.listener.close(p, this);
        }
    }

    public String toString() {
        return "OpenCryptoFile(path=" + this.currentFilePath.toString() + ")";
    }
}

