/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public class LooseDirFile
implements DiagnosticResult {
    final Path dirFile;

    LooseDirFile(Path dirFile) {
        this.dirFile = dirFile;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.INFO;
    }

    @Override
    public String toString() {
        return String.format("A dir.c9r without proper parent found: (%s). .", this.dirFile);
    }

    @Override
    public Optional<DiagnosticResult.Fix> getFix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) {
        return Optional.of(() -> this.fix(pathToVault));
    }

    void fix(Path pathToVault) throws IOException {
        Files.deleteIfExists(pathToVault.resolve(this.dirFile));
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID File", this.dirFile.toString());
    }
}

