/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemUri;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.common.ArrayUtils;

public class CryptoPath
implements Path {
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private final CryptoFileSystemImpl fileSystem;
    private final Symlinks symlinks;
    private final List<String> elements;
    private final boolean absolute;

    CryptoPath(CryptoFileSystemImpl fileSystem, Symlinks symlinks, List<String> elements, boolean absolute) {
        fileSystem.assertOpen();
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.symlinks = Objects.requireNonNull(symlinks);
        this.elements = Collections.unmodifiableList(elements);
        this.absolute = Objects.requireNonNull(absolute);
    }

    static CryptoPath castAndAssertAbsolute(Path path) {
        CryptoPath result = CryptoPath.cast(path);
        if (!result.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute but was " + String.valueOf(path));
        }
        return result;
    }

    static CryptoPath cast(Path path) {
        if (path instanceof CryptoPath) {
            CryptoPath p = (CryptoPath)path;
            p.getFileSystem().assertOpen();
            return p;
        }
        throw new ProviderMismatchException("Used a path from different provider: " + String.valueOf(path));
    }

    @Override
    public CryptoFileSystemImpl getFileSystem() {
        return this.fileSystem;
    }

    List<String> getElements() {
        return this.elements;
    }

    @Override
    public boolean isAbsolute() {
        this.fileSystem.assertOpen();
        return this.absolute;
    }

    @Override
    public CryptoPath getRoot() {
        this.fileSystem.assertOpen();
        return this.absolute ? this.fileSystem.getRootPath() : null;
    }

    @Override
    public CryptoPath getFileName() {
        this.fileSystem.assertOpen();
        int elementCount = this.getNameCount();
        if (elementCount == 0) {
            return null;
        }
        return this.getName(elementCount - 1);
    }

    @Override
    public CryptoPath getParent() {
        this.fileSystem.assertOpen();
        int elementCount = this.getNameCount();
        if (elementCount > 1) {
            List<String> elems = this.elements.subList(0, elementCount - 1);
            return this.copyWithElements(elems);
        }
        if (elementCount == 1) {
            return this.getRoot();
        }
        return null;
    }

    @Override
    public int getNameCount() {
        this.fileSystem.assertOpen();
        return this.elements.size();
    }

    @Override
    public CryptoPath getName(int index) {
        this.fileSystem.assertOpen();
        return this.subpath(index, index + 1);
    }

    @Override
    public CryptoPath subpath(int beginIndex, int endIndex) {
        List<String> sublist;
        this.fileSystem.assertOpen();
        try {
            sublist = this.elements.subList(beginIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
        return new CryptoPath(this.fileSystem, this.symlinks, sublist, false);
    }

    @Override
    public boolean startsWith(Path path) {
        boolean matchesAbsolute;
        this.fileSystem.assertOpen();
        if (!this.getFileSystem().equals(path.getFileSystem())) {
            return false;
        }
        CryptoPath other = CryptoPath.cast(path);
        boolean bl = matchesAbsolute = this.isAbsolute() == other.isAbsolute();
        if (matchesAbsolute && other.elements.size() <= this.elements.size()) {
            return this.elements.subList(0, other.elements.size()).equals(other.elements);
        }
        return false;
    }

    @Override
    public boolean startsWith(String other) {
        this.fileSystem.assertOpen();
        return this.startsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path path) {
        this.fileSystem.assertOpen();
        if (!this.getFileSystem().equals(path.getFileSystem())) {
            return false;
        }
        CryptoPath other = CryptoPath.cast(path);
        if (other.elements.size() <= this.elements.size()) {
            return this.elements.subList(this.elements.size() - other.elements.size(), this.elements.size()).equals(other.elements);
        }
        return false;
    }

    @Override
    public boolean endsWith(String other) {
        this.fileSystem.assertOpen();
        return this.endsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public CryptoPath normalize() {
        this.fileSystem.assertOpen();
        LinkedList<String> normalized = new LinkedList<String>();
        for (String elem : this.elements) {
            String lastElem = normalized.peekLast();
            if (elem.isEmpty() || CURRENT_DIR.equals(elem)) continue;
            if (PARENT_DIR.equals(elem) && lastElem != null && !PARENT_DIR.equals(lastElem)) {
                normalized.removeLast();
                continue;
            }
            normalized.add(elem);
        }
        return this.copyWithElements(normalized);
    }

    @Override
    public CryptoPath resolve(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath other = CryptoPath.cast(path);
        if (other.isAbsolute()) {
            return other;
        }
        ArrayList<String> joined = new ArrayList<String>();
        joined.addAll(this.elements);
        joined.addAll(other.elements);
        return this.copyWithElements(joined);
    }

    @Override
    public CryptoPath resolve(String other) {
        this.fileSystem.assertOpen();
        return this.resolve(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public CryptoPath resolveSibling(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath parent = this.getParent();
        CryptoPath other = CryptoPath.cast(path);
        if (parent == null || other.isAbsolute()) {
            return other;
        }
        return parent.resolve(other);
    }

    @Override
    public CryptoPath resolveSibling(String other) {
        this.fileSystem.assertOpen();
        return this.resolveSibling(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public CryptoPath relativize(Path path) {
        this.fileSystem.assertOpen();
        CryptoPath normalized = this.normalize();
        CryptoPath other = CryptoPath.cast(path).normalize();
        if (normalized.isAbsolute() == other.isAbsolute()) {
            int commonPrefix = this.countCommonPrefixElements(normalized, other);
            int stepsUp = this.getNameCount() - commonPrefix;
            ArrayList<String> elems = new ArrayList<String>();
            elems.addAll(Collections.nCopies(stepsUp, PARENT_DIR));
            elems.addAll(other.elements.subList(commonPrefix, other.getNameCount()));
            return this.copyWithElementsAndAbsolute(elems, false);
        }
        throw new IllegalArgumentException("Can't relativize an absolute path relative to a relative path.");
    }

    private int countCommonPrefixElements(CryptoPath p1, CryptoPath p2) {
        int n = Math.min(p1.getNameCount(), p2.getNameCount());
        for (int i = 0; i < n; ++i) {
            if (p1.elements.get(i).equals(p2.elements.get(i))) continue;
            return i;
        }
        return n;
    }

    @Override
    public URI toUri() {
        this.fileSystem.assertOpen();
        return CryptoFileSystemUri.create(this.fileSystem.getPathToVault(), this.elements.toArray(new String[this.elements.size()]));
    }

    @Override
    public CryptoPath toAbsolutePath() {
        this.fileSystem.assertOpen();
        if (this.isAbsolute()) {
            return this;
        }
        return this.copyWithAbsolute(true);
    }

    @Override
    public CryptoPath toRealPath(LinkOption ... options) throws IOException {
        this.fileSystem.assertOpen();
        CryptoPath normalized = this.normalize().toAbsolutePath();
        if (!ArrayUtils.contains(options, LinkOption.NOFOLLOW_LINKS)) {
            return normalized.resolveAllSymlinksInPath();
        }
        return normalized;
    }

    private CryptoPath resolveAllSymlinksInPath() throws IOException {
        if (this.getNameCount() > 1) {
            CryptoPath p = this.getParent().resolveAllSymlinksInPath().resolve(this.getFileName());
            return this.symlinks.resolveRecursively(p).normalize();
        }
        return this.symlinks.resolveRecursively(this).normalize();
    }

    @Override
    public File toFile() {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        this.fileSystem.assertOpen();
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public Iterator<Path> iterator() {
        this.fileSystem.assertOpen();
        return new Iterator<Path>(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < CryptoPath.this.getNameCount();
            }

            @Override
            public Path next() {
                try {
                    return CryptoPath.this.getName(this.idx++);
                }
                catch (IllegalArgumentException e) {
                    throw new NoSuchElementException(e);
                }
            }
        };
    }

    @Override
    public int compareTo(Path path) {
        CryptoPath other = (CryptoPath)path;
        if (this.isAbsolute() != other.isAbsolute()) {
            return this.isAbsolute() ? -1 : 1;
        }
        for (int i = 0; i < Math.min(this.getNameCount(), other.getNameCount()); ++i) {
            int result = this.elements.get(i).compareTo(other.elements.get(i));
            if (result == 0) continue;
            return result;
        }
        return this.getNameCount() - other.getNameCount();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + this.fileSystem.hashCode();
        hash = 31 * hash + this.elements.hashCode();
        hash = 31 * hash + (this.absolute ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CryptoPath) {
            CryptoPath other = (CryptoPath)obj;
            return this.fileSystem.equals(other.fileSystem) && this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        String prefix = this.absolute ? "/" : "";
        return prefix + String.join((CharSequence)"/", this.elements);
    }

    private CryptoPath copyWithElements(List<String> elements) {
        return new CryptoPath(this.fileSystem, this.symlinks, elements, this.absolute);
    }

    private CryptoPath copyWithAbsolute(boolean absolute) {
        return new CryptoPath(this.fileSystem, this.symlinks, this.elements, absolute);
    }

    private CryptoPath copyWithElementsAndAbsolute(List<String> elements, boolean absolute) {
        return new CryptoPath(this.fileSystem, this.symlinks, elements, absolute);
    }
}

