/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.InvalidClaimException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import org.cryptomator.cryptofs.VaultConfigLoadException;
import org.cryptomator.cryptofs.VaultKeyInvalidException;
import org.cryptomator.cryptofs.VaultVersionMismatchException;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoader;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;

public class VaultConfig {
    private static final String JSON_KEY_VAULTVERSION = "format";
    private static final String JSON_KEY_CIPHERCONFIG = "cipherCombo";
    private static final String JSON_KEY_SHORTENING_THRESHOLD = "shorteningThreshold";
    private final String id;
    private final int vaultVersion;
    private final CryptorProvider.Scheme cipherCombo;
    private final int shorteningThreshold;

    private VaultConfig(DecodedJWT verifiedConfig) {
        this.id = verifiedConfig.getId();
        this.vaultVersion = verifiedConfig.getClaim(JSON_KEY_VAULTVERSION).asInt();
        this.cipherCombo = CryptorProvider.Scheme.valueOf((String)verifiedConfig.getClaim(JSON_KEY_CIPHERCONFIG).asString());
        this.shorteningThreshold = verifiedConfig.getClaim(JSON_KEY_SHORTENING_THRESHOLD).asInt();
    }

    private VaultConfig(VaultConfigBuilder builder) {
        this.id = builder.id;
        this.vaultVersion = builder.vaultVersion;
        this.cipherCombo = builder.cipherCombo;
        this.shorteningThreshold = builder.shorteningThreshold;
    }

    public String getId() {
        return this.id;
    }

    public int getVaultVersion() {
        return this.vaultVersion;
    }

    public CryptorProvider.Scheme getCipherCombo() {
        return this.cipherCombo;
    }

    public int getShorteningThreshold() {
        return this.shorteningThreshold;
    }

    public String toToken(String keyId, byte[] rawKey) {
        return JWT.create().withKeyId(keyId).withJWTId(this.id).withClaim(JSON_KEY_VAULTVERSION, Integer.valueOf(this.vaultVersion)).withClaim(JSON_KEY_CIPHERCONFIG, this.cipherCombo.name()).withClaim(JSON_KEY_SHORTENING_THRESHOLD, Integer.valueOf(this.shorteningThreshold)).sign(Algorithm.HMAC256((byte[])rawKey));
    }

    public static VaultConfig load(String token, MasterkeyLoader keyLoader, int expectedVaultVersion) throws MasterkeyLoadingFailedException, VaultConfigLoadException {
        UnverifiedVaultConfig configLoader = VaultConfig.decode(token);
        byte[] rawKey = new byte[]{};
        try {
            VaultConfig vaultConfig;
            block9: {
                Masterkey key = keyLoader.loadKey(configLoader.getKeyId());
                try {
                    rawKey = key.getEncoded();
                    vaultConfig = configLoader.verify(rawKey, expectedVaultVersion);
                    if (key == null) break block9;
                }
                catch (Throwable throwable) {
                    if (key != null) {
                        try {
                            key.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                key.close();
            }
            return vaultConfig;
        }
        finally {
            Arrays.fill(rawKey, (byte)0);
        }
    }

    public static UnverifiedVaultConfig decode(String token) throws VaultConfigLoadException {
        try {
            return new UnverifiedVaultConfig(JWT.decode((String)token));
        }
        catch (JWTDecodeException e) {
            throw new VaultConfigLoadException("Failed to parse config: " + token);
        }
    }

    public static VaultConfigBuilder createNew() {
        return new VaultConfigBuilder();
    }

    public static class VaultConfigBuilder {
        private final String id = UUID.randomUUID().toString();
        private final int vaultVersion = 8;
        private CryptorProvider.Scheme cipherCombo;
        private int shorteningThreshold;

        public VaultConfigBuilder cipherCombo(CryptorProvider.Scheme cipherCombo) {
            this.cipherCombo = cipherCombo;
            return this;
        }

        public VaultConfigBuilder shorteningThreshold(int shorteningThreshold) {
            this.shorteningThreshold = shorteningThreshold;
            return this;
        }

        public VaultConfig build() {
            return new VaultConfig(this);
        }
    }

    public static class UnverifiedVaultConfig {
        private final DecodedJWT unverifiedConfig;

        private UnverifiedVaultConfig(DecodedJWT unverifiedConfig) {
            this.unverifiedConfig = unverifiedConfig;
        }

        public URI getKeyId() {
            return URI.create(this.unverifiedConfig.getKeyId());
        }

        public <T> T getHeader(String key, Class<T> clazz) {
            Claim claim = this.unverifiedConfig.getHeaderClaim(key);
            try {
                return (T)this.unverifiedConfig.getHeaderClaim(key).as(clazz);
            }
            catch (JWTDecodeException e) {
                throw new IllegalArgumentException("Can't convert " + String.valueOf(claim) + " to type " + clazz.getName(), e);
            }
        }

        public int allegedVaultVersion() {
            return this.unverifiedConfig.getClaim(VaultConfig.JSON_KEY_VAULTVERSION).asInt();
        }

        public int allegedShorteningThreshold() {
            return this.unverifiedConfig.getClaim(VaultConfig.JSON_KEY_SHORTENING_THRESHOLD).asInt();
        }

        private Algorithm initAlgorithm(byte[] rawKey) throws VaultConfigLoadException {
            String algo;
            return switch (algo = this.unverifiedConfig.getAlgorithm()) {
                case "HS256" -> Algorithm.HMAC256((byte[])rawKey);
                case "HS384" -> Algorithm.HMAC384((byte[])rawKey);
                case "HS512" -> Algorithm.HMAC512((byte[])rawKey);
                default -> throw new VaultConfigLoadException("Unsupported signature algorithm: " + algo);
            };
        }

        public VaultConfig verify(byte[] rawKey, int expectedVaultVersion) throws VaultKeyInvalidException, VaultVersionMismatchException, VaultConfigLoadException {
            try {
                this.unverifiedConfig.getAlgorithm();
                JWTVerifier verifier = JWT.require((Algorithm)this.initAlgorithm(rawKey)).withClaim(VaultConfig.JSON_KEY_VAULTVERSION, Integer.valueOf(expectedVaultVersion)).build();
                DecodedJWT verifiedConfig = verifier.verify(this.unverifiedConfig);
                return new VaultConfig(verifiedConfig);
            }
            catch (SignatureVerificationException e) {
                throw new VaultKeyInvalidException();
            }
            catch (InvalidClaimException e) {
                throw new VaultVersionMismatchException("Vault config not for version " + expectedVaultVersion);
            }
            catch (JWTVerificationException e) {
                throw new VaultConfigLoadException("Failed to verify vault config: " + this.unverifiedConfig.getToken());
            }
        }
    }
}

