/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.common.EncryptingWritableByteChannel;

@CryptoFileSystemScoped
public class DirectoryIdBackup {
    private Cryptor cryptor;

    @Inject
    public DirectoryIdBackup(Cryptor cryptor) {
        this.cryptor = cryptor;
    }

    public void execute(CiphertextDirectory ciphertextDirectory) throws IOException {
        try (SeekableByteChannel channel = Files.newByteChannel(ciphertextDirectory.path().resolve("dirid.c9r"), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
             EncryptingWritableByteChannel encryptingChannel = DirectoryIdBackup.wrapEncryptionAround(channel, this.cryptor);){
            encryptingChannel.write(ByteBuffer.wrap(ciphertextDirectory.dirId().getBytes(StandardCharsets.US_ASCII)));
        }
    }

    public static void backupManually(Cryptor cryptor, CiphertextDirectory ciphertextDirectory) throws IOException {
        new DirectoryIdBackup(cryptor).execute(ciphertextDirectory);
    }

    static EncryptingWritableByteChannel wrapEncryptionAround(ByteChannel channel, Cryptor cryptor) {
        return new EncryptingWritableByteChannel((WritableByteChannel)channel, cryptor);
    }
}

