/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AttributeComponent;
import org.cryptomator.cryptofs.common.ArrayUtils;
import org.cryptomator.cryptofs.common.CiphertextFileType;

@CryptoFileSystemScoped
public class AttributeProvider {
    private final AttributeComponent.Factory attributeComponentFactory;
    private final CryptoPathMapper pathMapper;
    private final Symlinks symlinks;

    @Inject
    AttributeProvider(AttributeComponent.Factory attributeComponentFactory, CryptoPathMapper pathMapper, Symlinks symlinks) {
        this.attributeComponentFactory = attributeComponentFactory;
        this.pathMapper = pathMapper;
        this.symlinks = symlinks;
    }

    public <A extends BasicFileAttributes> A readAttributes(CryptoPath cleartextPath, Class<A> type, LinkOption ... options) throws IOException {
        CiphertextFileType ciphertextFileType = this.pathMapper.getCiphertextFileType(cleartextPath);
        if (ciphertextFileType == CiphertextFileType.SYMLINK && !ArrayUtils.contains(options, LinkOption.NOFOLLOW_LINKS)) {
            cleartextPath = this.symlinks.resolveRecursively(cleartextPath);
            ciphertextFileType = this.pathMapper.getCiphertextFileType(cleartextPath);
        }
        Path ciphertextPath = this.getCiphertextPath(cleartextPath, ciphertextFileType);
        A ciphertextAttrs = Files.readAttributes(ciphertextPath, type, new LinkOption[0]);
        return this.attributeComponentFactory.create(ciphertextPath, ciphertextFileType, (BasicFileAttributes)ciphertextAttrs).attributes(type);
    }

    private Path getCiphertextPath(CryptoPath path, CiphertextFileType type) throws IOException {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case CiphertextFileType.SYMLINK -> this.pathMapper.getCiphertextFilePath(path).getSymlinkFilePath();
            case CiphertextFileType.DIRECTORY -> this.pathMapper.getCiphertextDir(path).path();
            case CiphertextFileType.FILE -> this.pathMapper.getCiphertextFilePath(path).getFilePath();
        };
    }
}

