/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public record MissingDirIdBackup(String dirId, Path contentDir) implements DiagnosticResult
{
    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.INFO;
    }

    @Override
    public String toString() {
        return String.format("Directory ID backup for directory %s is missing.", this.contentDir);
    }

    void fix(Path pathToVault, Cryptor cryptor) throws IOException {
        Path absCipherDir = pathToVault.resolve(this.contentDir);
        DirectoryIdBackup.backupManually(cryptor, new CiphertextDirectory(this.dirId, absCipherDir));
    }

    @Override
    public Optional<DiagnosticResult.Fix> getFix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) {
        return Optional.of(() -> this.fix(pathToVault, cryptor));
    }
}

