/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.cryptomator.cryptolib.org.bouncycastle.crypto.generators.SCrypt;

public class Scrypt {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] scrypt(CharSequence passphrase, byte[] salt, int costParam, int blockSize, int keyLengthInBytes) {
        ByteBuffer buf = UTF_8.encode(CharBuffer.wrap(passphrase));
        byte[] pw = new byte[buf.remaining()];
        buf.get(pw);
        try {
            byte[] byArray = SCrypt.generate(pw, salt, costParam, blockSize, 1, keyLengthInBytes);
            return byArray;
        }
        finally {
            Arrays.fill(pw, (byte)0);
            buf.rewind();
            buf.put(pw);
        }
    }
}

