/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileContentCryptorImpl
implements FileContentCryptor {
    private final SecretKey macKey;
    private final SecureRandom random;

    FileContentCryptorImpl(SecretKey macKey, SecureRandom random) {
        this.macKey = macKey;
        this.random = random;
    }

    @Override
    public int cleartextChunkSize() {
        return 32768;
    }

    @Override
    public int ciphertextChunkSize() {
        return 32816;
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, FileHeader header) {
        if (cleartextChunk.remaining() == 0 || cleartextChunk.remaining() > 32768) {
            throw new IllegalArgumentException("Invalid chunk");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        return this.encryptChunk(cleartextChunk.asReadOnlyBuffer(), chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey());
    }

    @Override
    public ByteBuffer decryptChunk(ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        if (ciphertextChunk.remaining() < 48 || ciphertextChunk.remaining() > 32816) {
            throw new IllegalArgumentException("Invalid chunk size: " + ciphertextChunk.remaining() + ", expected range [" + 48 + ", " + 32816 + "]");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        if (authenticate && !this.checkChunkMac(headerImpl.getNonce(), chunkNumber, ciphertextChunk.asReadOnlyBuffer())) {
            throw new AuthenticationFailedException("Authentication of chunk " + chunkNumber + " failed.");
        }
        return this.decryptChunk(ciphertextChunk.asReadOnlyBuffer(), headerImpl.getPayload().getContentKey());
    }

    ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, byte[] headerNonce, SecretKey fileKey) {
        try {
            byte[] nonce = new byte[16];
            this.random.nextBytes(nonce);
            Cipher cipher = CipherSupplier.AES_CTR.forEncryption(fileKey, new IvParameterSpec(nonce));
            ByteBuffer outBuf = ByteBuffer.allocate(16 + cipher.getOutputSize(cleartextChunk.remaining()) + 32);
            outBuf.put(nonce);
            int bytesEncrypted = cipher.doFinal(cleartextChunk, outBuf);
            ByteBuffer ciphertextBuf = outBuf.asReadOnlyBuffer();
            ciphertextBuf.position(16).limit(16 + bytesEncrypted);
            byte[] authenticationCode = FileContentCryptorImpl.calcChunkMac(this.macKey, headerNonce, chunkNumber, nonce, ciphertextBuf);
            assert (authenticationCode.length == 32);
            outBuf.put(authenticationCode);
            outBuf.flip();
            return outBuf;
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
    }

    ByteBuffer decryptChunk(ByteBuffer ciphertextChunk, SecretKey fileKey) {
        assert (ciphertextChunk.remaining() >= 48);
        try {
            byte[] nonce = new byte[16];
            ByteBuffer chunkNonceBuf = ciphertextChunk.asReadOnlyBuffer();
            chunkNonceBuf.position(0).limit(16);
            chunkNonceBuf.get(nonce);
            ByteBuffer payloadBuf = ciphertextChunk.asReadOnlyBuffer();
            payloadBuf.position(16).limit(ciphertextChunk.limit() - 32);
            Cipher cipher = CipherSupplier.AES_CTR.forDecryption(fileKey, new IvParameterSpec(nonce));
            ByteBuffer outBuf = ByteBuffer.allocate(cipher.getOutputSize(payloadBuf.remaining()));
            cipher.doFinal(payloadBuf, outBuf);
            outBuf.flip();
            return outBuf;
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
    }

    boolean checkChunkMac(byte[] headerNonce, long chunkNumber, ByteBuffer chunkBuf) {
        assert (chunkBuf.remaining() >= 48);
        ByteBuffer chunkNonceBuf = chunkBuf.asReadOnlyBuffer();
        chunkNonceBuf.position(0).limit(16);
        ByteBuffer payloadBuf = chunkBuf.asReadOnlyBuffer();
        payloadBuf.position(16).limit(chunkBuf.limit() - 32);
        ByteBuffer expectedMacBuf = chunkBuf.asReadOnlyBuffer();
        expectedMacBuf.position(chunkBuf.limit() - 32);
        byte[] chunkNonce = new byte[16];
        chunkNonceBuf.get(chunkNonce);
        byte[] expectedMac = new byte[32];
        expectedMacBuf.get(expectedMac);
        byte[] calculatedMac = FileContentCryptorImpl.calcChunkMac(this.macKey, headerNonce, chunkNumber, chunkNonce, payloadBuf);
        return MessageDigest.isEqual(expectedMac, calculatedMac);
    }

    private static byte[] calcChunkMac(SecretKey macKey, byte[] headerNonce, long chunkNumber, byte[] chunkNonce, ByteBuffer ciphertext) {
        byte[] chunkNumberBigEndian = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(chunkNumber).array();
        Mac mac = MacSupplier.HMAC_SHA256.withKey(macKey);
        mac.update(headerNonce);
        mac.update(chunkNumberBigEndian);
        mac.update(chunkNonce);
        mac.update(ciphertext);
        return mac.doFinal();
    }
}

